/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class Display8bit
extends ModTileEntity
implements IRedstone8bit,
IPeripheral,
Environment {
    private boolean update;
    public byte state;
    public byte dspType;
    private ArrayList<Object> listeners = new ArrayList();
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"RedstoneCircuits-In8bit", (boolean)false);

    public boolean onActivated(EntityPlayer player, int s, float X, float Y, float Z) {
        if (!player.func_70093_af() && s == this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.dspType = (byte)((this.dspType + 1) % 3);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.state = pkt.func_148857_g().func_74771_c("state");
        this.dspType = pkt.func_148857_g().func_74771_c("dsp");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", this.state);
        nbt.func_74774_a("dsp", this.dspType);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbt);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            byte lstate = this.state;
            this.state = 0;
            for (int i = 0; i < 6; ++i) {
                TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) <= 0) continue;
                this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1));
            }
            if (this.state != lstate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.updateEvent();
            }
        }
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("state", this.state);
        nbt.func_74774_a("mode", this.dspType);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = nbt.func_74771_c("state");
        this.dspType = nbt.func_74771_c("mode");
        this.update = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        return -1;
    }

    public void setValue(int s, byte v, int recursion) {
        this.update = true;
    }

    private void updateEvent() {
        for (Object computer : this.listeners) {
            ComputerAPI.sendEvent((Object)computer, (String)"in8bit", (Object[])new Object[]{this.state});
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "RedstoneCircuits-In8bit";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getInput"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext lua, int cmd, Object[] par) throws LuaException {
        if (cmd == 0) {
            return new Object[]{(double)this.state};
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        this.listeners.add(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        this.listeners.remove(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral peripheral) {
        return ((Object)((Object)this)).hashCode() == peripheral.hashCode();
    }

    public void func_145843_s() {
        super.func_145843_s();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.add(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.remove(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] getInput(Context cont, Arguments args) {
        return new Object[]{this.state};
    }
}

