/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class Circuit
extends AutomatedTile
implements IRedstone8bit,
IRedstone1bit {
    private final byte[] io = new byte[4];
    private final byte[] ram = new byte[16];
    private final byte[] obj = new byte[32];
    private byte[] code = new byte[0];
    public String name = "";
    private int var;
    private short timer = 0;
    private boolean update;

    public Circuit() {
        this.netData = new TileEntityData(1, 1, 0, 0);
        this.netData.ints[0] = 1;
    }

    public String func_145825_b() {
        return "Redstone Circuit" + (this.name.length() > 0 ? " (".concat(this.name).concat(")") : "");
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.timer = (short)(this.timer + 1);
        if (this.getConfig(6) == 0) {
            this.timer = 0;
        }
        if (this.timer >= this.netData.ints[0]) {
            int c;
            byte d8;
            byte d1;
            this.timer = 0;
            if (this.update) {
                this.io[1] = 0;
                this.io[0] = 0;
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                    d1 = this.getBitDirection(i);
                    d8 = this.getDirection(i);
                    if (d1 > -1 && d8 > -1) continue;
                    c = this.getConfig(i);
                    TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                    if (d8 < 0 && te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) > 0) {
                        int n = c >> 4;
                        this.io[n] = (byte)(this.io[n] | ((IRedstone8bit)te).getValue(i ^ 1));
                        continue;
                    }
                    if (d1 >= 0 || (te == null || !(te instanceof IRedstone1bit) || ((IRedstone1bit)te).getBitDirection(i ^ 1) <= 0 || !((IRedstone1bit)te).getBitValue(i ^ 1)) && !this.field_145850_b.func_94574_k(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, i)) continue;
                    int n = c >> 4;
                    this.io[n] = (byte)(this.io[n] | 1 << (c & 0xF) - 2);
                }
                this.update = false;
            }
            byte l2 = this.io[2];
            byte l3 = this.io[3];
            this.cpuTick();
            if (this.io[2] != l2 || this.io[3] != l3) {
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                    d1 = this.getBitDirection(i);
                    d8 = this.getDirection(i);
                    if (d1 < 1 && d8 < 1) continue;
                    c = this.getConfig(i);
                    TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                    if (d8 > 0 && te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) < 0) {
                        ((IRedstone8bit)te).setValue(i ^ 1, this.io[c >> 4], 1);
                        continue;
                    }
                    if (d1 <= 0) continue;
                    if (te != null && te instanceof IRedstone1bit && ((IRedstone1bit)te).getBitDirection(i ^ 1) < 0) {
                        ((IRedstone1bit)te).setBitValue(i ^ 1, (this.io[c >> 4] >> (c & 0xF) - 2 & 1) != 0, 1);
                        continue;
                    }
                    this.notifyStateChange(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                }
            }
        }
    }

    private void cpuTick() {
        boolean x = false;
        byte n = 0;
        int i = 0;
        int j = 0;
        while (i < this.code.length) {
            int cmd = this.code[i] & 0xF0;
            int con = this.code[i] & 0xF;
            switch (cmd) {
                case 0: {
                    x = false;
                    while (i < j + con) {
                        x |= this.get(this.code[++i]);
                    }
                    break;
                }
                case 16: {
                    x = false;
                    while (i < j + con) {
                        x |= this.get(this.code[++i]);
                    }
                    x = !x;
                    break;
                }
                case 32: {
                    x = true;
                    while (i < j + con) {
                        x &= this.get(this.code[++i]);
                    }
                    break;
                }
                case 48: {
                    x = true;
                    while (i < j + con) {
                        x &= this.get(this.code[++i]);
                    }
                    x = !x;
                    break;
                }
                case 64: {
                    x = false;
                    while (i < j + con) {
                        x ^= this.get(this.code[++i]);
                    }
                    break;
                }
                case 80: {
                    x = true;
                    while (i < j + con) {
                        x ^= this.get(this.code[++i]);
                    }
                    break;
                }
                case 96: {
                    x = (this.io[con >> 3] & 1 << (con & 7)) != 0;
                    break;
                }
                case 112: {
                    x = this.ram[con] == this.code[++i];
                    break;
                }
                case -128: {
                    x = this.ram[con] < this.code[++i];
                    break;
                }
                case -112: {
                    x = this.ram[con] > this.code[++i];
                }
            }
            byte by = n;
            n = (byte)(n + 1);
            this.set(by, x);
            j = ++i;
        }
        for (i = 0; i < 8; ++i) {
            if (this.get(this.obj[i | 8])) {
                this.ram[i | 8] = 0;
                continue;
            }
            if (!this.get(this.obj[i])) continue;
            int n2 = i | 8;
            this.ram[n2] = (byte)(this.ram[n2] + 1);
        }
        this.io[3] = 0;
        this.io[2] = 0;
        for (i = 0; i < 16; ++i) {
            if (!this.get(this.obj[i | 0x10])) continue;
            int n3 = i >> 3 | 2;
            this.io[n3] = (byte)(this.io[n3] | 1 << (i & 7));
        }
    }

    private boolean get(byte i) {
        return i >= 0 && (this.ram[i >> 3] & 1 << (i & 7)) != 0;
    }

    private void set(byte i, boolean s) {
        if (s) {
            int n = i >> 3;
            this.ram[n] = (byte)(this.ram[n] | 1 << (i & 7));
        } else {
            int n = i >> 3;
            this.ram[n] = (byte)(this.ram[n] & ~(1 << (i & 7)));
        }
    }

    public int getConfig(int s) {
        return (int)(this.netData.longs[0] >> (int)((long)s * 6L) & 0x3FL);
    }

    public void setConfig(int s, int v) {
        this.netData.longs[0] = this.netData.longs[0] & (63L << (int)((long)s * 6L) ^ 0xFFFFFFFFFFFFFFFFL);
        this.netData.longs[0] = this.netData.longs[0] | ((long)v & 0x3FL) << (int)((long)s * 6L);
    }

    protected void customPlayerCommand(byte cmd, DataInputStream dis, EntityPlayerMP player) throws IOException {
        if (cmd == 0) {
            Arrays.fill(this.ram, (byte)0);
        } else if (cmd == 1) {
            this.netData.ints[0] = dis.readInt();
            if (this.netData.ints[0] < 1) {
                this.netData.ints[0] = 1;
            } else if (this.netData.ints[0] > 1200) {
                this.netData.ints[0] = 1200;
            }
        } else if (cmd == 2) {
            this.netData.longs[0] = dis.readLong();
            this.update = true;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74773_a("ram", this.ram);
        nbt.func_74773_a("io", this.io);
        nbt.func_74773_a("obj", this.obj);
        nbt.func_74773_a("code", this.code);
        nbt.func_74768_a("var", this.var);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("tick", this.netData.ints[0]);
        nbt.func_74772_a("cfg", this.netData.longs[0]);
        nbt.func_74777_a("timer", this.timer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        byte[] b = nbt.func_74770_j("ram");
        System.arraycopy(b, 0, this.ram, 0, Math.min(this.ram.length, b.length));
        b = nbt.func_74770_j("io");
        System.arraycopy(b, 0, this.io, 0, Math.min(this.io.length, b.length));
        b = nbt.func_74770_j("obj");
        System.arraycopy(b, 0, this.obj, 0, Math.min(this.obj.length, b.length));
        this.code = nbt.func_74770_j("code");
        this.var = nbt.func_74762_e("var");
        this.name = nbt.func_74779_i("name");
        this.timer = nbt.func_74765_d("timer");
        this.netData.ints[0] = nbt.func_74762_e("tick");
        this.netData.longs[0] = nbt.func_74763_f("cfg");
        this.update = true;
    }

    public ArrayList<ItemStack> dropItem(int m, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack item = new ItemStack(this.func_145838_q());
        item.field_77990_d = new NBTTagCompound();
        item.field_77990_d.func_74774_a("InOut", (byte)(this.var & 0xFF));
        item.field_77990_d.func_74774_a("Gates", (byte)(this.var >> 8 & 0xFF));
        item.field_77990_d.func_74774_a("Count", (byte)(this.var >> 16 & 0xFF));
        if (this.code.length > 0) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", this.name);
            nbt.func_74773_a("code", this.code);
            nbt.func_74773_a("cnt", Arrays.copyOfRange(this.obj, 0, 16));
            nbt.func_74773_a("out", Arrays.copyOfRange(this.obj, 16, 32));
            item.field_77990_d.func_74782_a("Progr", (NBTBase)nbt);
        }
        list.add(item);
        return list;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.field_77990_d != null) {
            this.var = 0;
            this.var |= item.field_77990_d.func_74771_c("InOut") & 0xFF;
            this.var |= item.field_77990_d.func_74771_c("Gates") << 8 & 0xFF00;
            this.var |= item.field_77990_d.func_74771_c("Count") << 16 & 0xFF0000;
            if (item.field_77990_d.func_74764_b("Progr")) {
                NBTTagCompound nbt = item.field_77990_d.func_74775_l("Progr");
                this.code = nbt.func_74770_j("code");
                byte[] b = nbt.func_74770_j("out");
                System.arraycopy(b, 0, this.obj, 16, Math.min(16, b.length));
                b = nbt.func_74770_j("cnt");
                System.arraycopy(b, 0, this.obj, 0, Math.min(16, b.length));
                this.name = nbt.func_74779_i("name");
            }
        }
    }

    public byte getValue(int s) {
        int c = this.getConfig(s);
        int c1 = c & 0xF;
        int c2 = c >> 4;
        if (c2 >= 2 && c1 == 1) {
            return this.io[c2];
        }
        return 0;
    }

    public byte getDirection(int s) {
        int c = this.getConfig(s);
        if ((c & 0xF) != 1) {
            return 0;
        }
        return (byte)(c < 32 ? -1 : 1);
    }

    public void setValue(int s, byte v, int recursion) {
        this.update = true;
    }

    public byte getBitDirection(int s) {
        int c = this.getConfig(s);
        if ((c & 0xF) >= 2) {
            return c >= 32 ? (byte)1 : -1;
        }
        return 0;
    }

    public boolean getBitValue(int s) {
        int c = this.getConfig(s);
        int c1 = c & 0xF;
        int c2 = c >> 4;
        if (c2 >= 2 && c1 >= 2) {
            return (this.io[c2] & 1 << c - 2) != 0;
        }
        return false;
    }

    public void setBitValue(int s, boolean v, int recursion) {
        this.update = true;
    }

    private void notifyStateChange(int x, int y, int z) {
        this.field_145850_b.func_147460_e(x, y, z, this.func_145838_q());
        this.field_145850_b.func_147459_d(x, y, z, this.func_145838_q());
    }

    public int redstoneLevel(int s, boolean str) {
        return this.getBitValue(s) ? 15 : 0;
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }
}

