/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Obj2;
import cd4017be.lib.util.Utils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TankContainer
implements IFluidHandler {
    public int netIdxLong = 0;
    public int netIdxFluid = 0;
    public final Tank[] tanks;
    private final ModTileEntity tile;

    public TankContainer(ModTileEntity tile, Tank ... config) {
        this.tile = tile;
        this.tanks = config == null ? new Tank[]{} : config;
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.tanks[i].types == null || this.tanks[i].types.length != 1) continue;
            tile.netData.fluids[this.netIdxFluid + i] = new FluidStack(this.tanks[i].types[0], 0);
        }
    }

    public TankContainer setNetLong(int idx) {
        this.netIdxLong = idx;
        return this;
    }

    public void update() {
        for (int id = 0; id < this.tanks.length; ++id) {
            if (this.tanks[id].dir == 0) continue;
            for (int s = 0; s < 6; ++s) {
                IFluidHandler handler;
                ForgeDirection dir;
                TileEntity te;
                byte cfg = this.getConfig(s, id);
                if (cfg == 0) continue;
                if (this.tanks[id].dir > 0 && cfg == 3 && this.getAmount(id) > 0) {
                    te = Utils.getTileOnSide(this.tile, (byte)s);
                    if (!(te instanceof IFluidHandler)) continue;
                    dir = ForgeDirection.getOrientation((int)(s ^ 1));
                    handler = (IFluidHandler)te;
                    this.drain(id, handler.fill(dir, this.getFluid(id), true), true);
                    continue;
                }
                if (this.tanks[id].dir >= 0 || cfg != 2 || this.getSpace(id) <= 0 || !((te = Utils.getTileOnSide(this.tile, (byte)s)) instanceof IFluidHandler)) continue;
                dir = ForgeDirection.getOrientation((int)(s ^ 1));
                handler = (IFluidHandler)te;
                int am = this.getSpace(id);
                FluidStack stack = null;
                if (this.getFluid(id) != null) {
                    stack = new FluidStack(this.getFluid(id), am);
                } else if (this.tanks[id].types.length > 0) {
                    for (Fluid type : this.tanks[id].types) {
                        if (!handler.canDrain(dir, type)) continue;
                        stack = new FluidStack(type, am);
                        break;
                    }
                    if (stack == null) continue;
                }
                this.fill(id, stack == null ? handler.drain(dir, am, true) : handler.drain(dir, stack, true), true);
            }
        }
        if (this.tile instanceof IInventory) {
            IInventory inv = (IInventory)this.tile;
            for (int id = 0; id < this.tanks.length; ++id) {
                Obj2<ItemStack, Object> output;
                ItemStack item;
                if (this.tanks[id].inSlot >= 0 && this.tanks[id].inSlot < inv.func_70302_i_() && this.getSpace(id) > 0) {
                    item = inv.func_70301_a(this.tanks[id].inSlot);
                    if (this.getFluid(id) == null || this.getFluid(id).isFluidEqual(item)) {
                        output = Utils.drainFluid(item, this.getSpace(id));
                        this.fill(id, (FluidStack)output.objB, true);
                        inv.func_70299_a(this.tanks[id].inSlot, (ItemStack)output.objA);
                    }
                }
                if (this.tanks[id].outSlot < 0 || this.tanks[id].outSlot >= inv.func_70302_i_() || this.getAmount(id) <= 0) continue;
                item = inv.func_70301_a(this.tanks[id].outSlot);
                output = Utils.fillFluid(item, this.getFluid(id));
                this.drain(id, (int)((Integer)output.objB), true);
                inv.func_70299_a(this.tanks[id].outSlot, (ItemStack)output.objA);
            }
        }
    }

    public FluidStack getFluid(int id) {
        return this.tile.netData.fluids[this.netIdxFluid + id];
    }

    public void setFluid(int id, FluidStack fluid) {
        if (fluid != null && fluid.amount == 0) {
            fluid = null;
        }
        if (fluid == null && this.tile.netData.fluids[this.netIdxFluid + id] != null && this.isLocked(id)) {
            this.tile.netData.fluids[this.netIdxFluid + id].amount = 0;
        } else {
            this.tile.netData.fluids[this.netIdxFluid + id] = fluid;
        }
    }

    public int getAmount(int id) {
        FluidStack stack = this.tile.netData.fluids[this.netIdxFluid + id];
        return stack == null ? 0 : stack.amount;
    }

    public int getSpace(int id) {
        FluidStack stack = this.tile.netData.fluids[this.netIdxFluid + id];
        return stack == null ? this.tanks[id].cap : this.tanks[id].cap - stack.amount;
    }

    public int fill(int id, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack stack = this.getFluid(id);
        if (stack != null && !stack.isFluidEqual(resource)) {
            return 0;
        }
        int m = this.tanks[id].cap - (stack == null ? 0 : stack.amount);
        if (m > resource.amount) {
            m = resource.amount;
        }
        if (doFill) {
            if (stack == null) {
                stack = resource.copy();
                stack.amount = m;
            } else {
                stack.amount += m;
            }
            this.setFluid(id, stack);
        }
        return m;
    }

    public FluidStack drain(int id, int amount, boolean doDrain) {
        FluidStack stack = this.getFluid(id);
        if (stack == null || amount <= 0) {
            return null;
        }
        int m = stack.amount;
        if (m > amount) {
            m = amount;
        }
        FluidStack ret = stack.copy();
        if (doDrain) {
            stack.amount -= m;
            if (stack.amount <= 0) {
                stack = null;
            }
            this.setFluid(id, stack);
        }
        ret.amount = m;
        return ret;
    }

    private byte getConfig(int s, int id) {
        return (byte)(this.tile.netData.longs[this.netIdxLong] >> 2 * s + 16 * id & 3L);
    }

    public boolean isLocked(int id) {
        return this.tanks[id].types.length == 1 || (this.tile.netData.longs[this.netIdxLong] >> 12 + 16 * id & 1L) != 0L;
    }

    private boolean canFillTank(int side, Fluid type, int id) {
        byte cfg = this.getConfig(side, id);
        if (cfg == 0 || cfg == 3) {
            return false;
        }
        FluidStack stack = this.getFluid(id);
        if (stack != null) {
            return stack.getFluid().equals(type) && stack.amount < this.tanks[id].cap;
        }
        if (this.tanks[id].types.length > 0) {
            for (Fluid fluid : this.tanks[id].types) {
                if (!fluid.equals(type)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean canDrainTank(int side, Fluid type, int id) {
        byte cfg = this.getConfig(side, id);
        if (cfg == 0 || cfg == 2) {
            return false;
        }
        FluidStack stack = this.getFluid(id);
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return type == null || stack.getFluid().equals(type);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int ref = -1;
        for (int id = 0; id < this.tanks.length; ++id) {
            if (!this.canFillTank(from.ordinal(), resource.getFluid(), id) || ref != -1 && this.tanks[id].dir >= this.tanks[ref].dir && (this.tanks[id].dir != this.tanks[ref].dir || this.getSpace(id) <= this.getSpace(ref))) continue;
            ref = id;
        }
        if (ref >= 0) {
            return this.fill(ref, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int ref = -1;
        for (int id = 0; id < this.tanks.length; ++id) {
            if (!this.canDrainTank(from.ordinal(), resource.getFluid(), id) || ref != -1 && this.tanks[id].dir <= this.tanks[ref].dir && (this.tanks[id].dir != this.tanks[ref].dir || this.getAmount(id) <= this.getAmount(ref))) continue;
            ref = id;
        }
        if (ref >= 0) {
            return this.drain(ref, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int ref = -1;
        for (int id = 0; id < this.tanks.length; ++id) {
            if (!this.canDrainTank(from.ordinal(), null, id) || ref != -1 && this.tanks[id].dir <= this.tanks[ref].dir && (this.tanks[id].dir != this.tanks[ref].dir || this.getAmount(id) <= this.getAmount(ref))) continue;
            ref = id;
        }
        if (ref >= 0) {
            return this.drain(ref, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (int id = 0; id < this.tanks.length; ++id) {
            if (!this.canFillTank(from.ordinal(), fluid, id)) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        for (int id = 0; id < this.tanks.length; ++id) {
            if (!this.canDrainTank(from.ordinal(), fluid, id)) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] array = new FluidTankInfo[this.tanks.length];
        int n = 0;
        for (int id = 0; id < this.tanks.length; ++id) {
            if (this.getConfig(from.ordinal(), id) == 0) continue;
            array[n++] = new FluidTankInfo(this.getFluid(id), this.tanks[id].cap);
        }
        FluidTankInfo[] info = new FluidTankInfo[n];
        System.arraycopy(array, 0, info, 0, n);
        return info;
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        for (int id = 0; id < this.tanks.length; ++id) {
            String tagName = name + Integer.toString(id);
            if (nbt.func_74764_b(tagName)) {
                this.setFluid(id, FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(tagName)));
                continue;
            }
            this.setFluid(id, null);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        for (int id = 0; id < this.tanks.length; ++id) {
            FluidStack stack = this.getFluid(id);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            stack.writeToNBT(tag);
            nbt.func_74782_a(name + Integer.toString(id), (NBTBase)tag);
        }
    }

    public static class Tank {
        public final int cap;
        public final byte dir;
        public Fluid[] types;
        public int inSlot = -1;
        public int outSlot = -1;

        public Tank(int cap, int dir, Fluid ... types) {
            this.cap = cap;
            this.types = types;
            this.dir = (byte)dir;
        }

        public Tank setIn(int slot) {
            this.inSlot = slot;
            return this;
        }

        public Tank setOut(int slot) {
            this.outSlot = slot;
            return this;
        }
    }
}

