/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.TileBlock;
import cd4017be.lib.templates.BlockPipe;
import cd4017be.lib.templates.IPipe;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class PipeRenderer
implements ISimpleBlockRenderingHandler {
    public final int renderId = RenderingRegistry.getNextAvailableRenderId();
    private final float blockBounds = 0.25f;
    private final float maxBounds = 1.0f;
    private final float minBounds = 0.0f;

    public void setRenderMachine(TileBlock block) {
        block.setRenderType(this.renderId);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof IPipe)) {
            return false;
        }
        IPipe.Cover cover = ((IPipe)te).getCover();
        if (cover != null && this.renderCover(renderer, world, x, y, z, cover, block)) {
            return true;
        }
        boolean renderAllFaces = renderer.field_147837_f;
        boolean flipTexture = renderer.field_147842_e;
        int uvRotateBottom = renderer.field_147865_v;
        int uvRotateTop = renderer.field_147867_u;
        int uvRotateEast = renderer.field_147875_q;
        int uvRotateWest = renderer.field_147873_r;
        int uvRotateNorth = renderer.field_147869_t;
        int uvRotateSouth = renderer.field_147871_s;
        renderer.field_147837_f = true;
        renderer.field_147842_e = false;
        float size = block instanceof BlockPipe ? ((BlockPipe)block).size : 0.25f;
        for (byte dir = 0; dir < 6; dir = (byte)(dir + 1)) {
            int tex = ((IPipe)te).textureForSide(dir);
            if (tex < 0) continue;
            this.setBlockBoundsForDir(renderer, dir, size);
            renderer.func_147757_a(block.func_149691_a(0, tex));
            renderer.func_147784_q(block, x, y, z);
        }
        renderer.func_147771_a();
        this.setBlockBoundsForDir(renderer, (byte)6, size);
        renderer.func_147784_q(block, x, y, z);
        renderer.func_147762_c();
        renderer.field_147837_f = renderAllFaces;
        renderer.field_147842_e = flipTexture;
        renderer.field_147865_v = uvRotateBottom;
        renderer.field_147867_u = uvRotateTop;
        renderer.field_147875_q = uvRotateEast;
        renderer.field_147873_r = uvRotateWest;
        renderer.field_147869_t = uvRotateNorth;
        renderer.field_147871_s = uvRotateSouth;
        return true;
    }

    private boolean renderCover(RenderBlocks renderer, IBlockAccess world, int x, int y, int z, IPipe.Cover cover, Block block) {
        float f5;
        float f4;
        float f3;
        Block cBlock = cover.blockId;
        if (cBlock == null) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int l = cBlock.func_149741_i(cover.meta);
        float r = (float)(l >> 16 & 0xFF) / 255.0f;
        float g = (float)(l >> 8 & 0xFF) / 255.0f;
        float b = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            f3 = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            f4 = (r * 30.0f + g * 70.0f) / 100.0f;
            f5 = (r * 30.0f + b * 70.0f) / 100.0f;
            r = f3;
            g = f4;
            b = f5;
        }
        f3 = 0.5f;
        f4 = 1.0f;
        f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * r;
        float f8 = f4 * g;
        float f9 = f4 * b;
        float f10 = f3 * r;
        float f11 = f5 * r;
        float f12 = f6 * r;
        float f13 = f3 * g;
        float f14 = f5 * g;
        float f15 = f6 * g;
        float f16 = f3 * b;
        float f17 = f5 * b;
        float f18 = f6 * b;
        tessellator.func_78380_c(block.func_149677_c(world, x, y - 1, z));
        tessellator.func_78386_a(f10, f13, f16);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 0, cover.meta));
        tessellator.func_78380_c(block.func_149677_c(world, x, y + 1, z));
        tessellator.func_78386_a(f7, f8, f9);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 1, cover.meta));
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z - 1));
        tessellator.func_78386_a(f11, f14, f17);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 2, cover.meta));
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z + 1));
        tessellator.func_78386_a(f11, f14, f17);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 3, cover.meta));
        tessellator.func_78380_c(block.func_149677_c(world, x - 1, y, z));
        tessellator.func_78386_a(f12, f15, f18);
        renderer.func_147798_e(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 4, cover.meta));
        tessellator.func_78380_c(block.func_149677_c(world, x + 1, y, z));
        tessellator.func_78386_a(f12, f15, f18);
        renderer.func_147764_f(block, (double)x, (double)y, (double)z, renderer.func_147787_a(cBlock, 5, cover.meta));
        return true;
    }

    public int getRenderId() {
        return this.renderId;
    }

    private void setBlockBoundsForDir(RenderBlocks renderer, byte dir, float size) {
        float[] bb = new float[6];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = i < 3 ? (1.0f - size) / 2.0f : (1.0f + size) / 2.0f;
        }
        if (dir == 4) {
            bb[3] = bb[0];
            bb[0] = 0.0f;
            renderer.field_147867_u = 0;
            renderer.field_147865_v = 0;
            renderer.field_147875_q = 0;
            renderer.field_147873_r = 0;
        } else if (dir == 5) {
            bb[0] = bb[3];
            bb[3] = 1.0f;
            renderer.field_147867_u = 0;
            renderer.field_147865_v = 0;
            renderer.field_147875_q = 0;
            renderer.field_147873_r = 0;
        } else if (dir == 0) {
            bb[4] = bb[1];
            bb[1] = 0.0f;
            renderer.field_147875_q = 1;
            renderer.field_147873_r = 1;
            renderer.field_147869_t = 1;
            renderer.field_147871_s = 1;
        } else if (dir == 1) {
            bb[1] = bb[4];
            bb[4] = 1.0f;
            renderer.field_147875_q = 1;
            renderer.field_147873_r = 1;
            renderer.field_147869_t = 1;
            renderer.field_147871_s = 1;
        } else if (dir == 2) {
            bb[5] = bb[2];
            bb[2] = 0.0f;
            renderer.field_147867_u = 1;
            renderer.field_147865_v = 1;
            renderer.field_147869_t = 0;
            renderer.field_147871_s = 0;
        } else if (dir == 3) {
            bb[2] = bb[5];
            bb[5] = 1.0f;
            renderer.field_147867_u = 1;
            renderer.field_147865_v = 1;
            renderer.field_147869_t = 0;
            renderer.field_147871_s = 0;
        }
        renderer.func_147770_b((double)bb[0], (double)bb[1], (double)bb[2], (double)bb[3], (double)bb[4], (double)bb[5]);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

