/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlock;
import cd4017be.lib.TileContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;

public class TileBlockRegistry {
    private static HashMap<Block, TileBlockEntry> registry = new HashMap();

    @SideOnly(value=Side.CLIENT)
    public static void registerGui(Block id, Class<? extends GuiContainer> gui) {
        TileBlockEntry entry = registry.get(id);
        if (entry != null) {
            if (entry.gui != null) {
                FMLLog.warning((String)"CD4017BE-modlib: GuiContainer %1$s overrrides already registered GuiContainer %2$s for Block-ID %3$d !", (Object[])new Object[]{gui.getName(), entry.gui.getName(), id});
            }
            entry.gui = gui;
        } else {
            FMLLog.warning((String)"CD4017BE-modlib: Failed to register GuiContainer %1$s because Block-ID %2$d is not registered!", (Object[])new Object[]{gui.getName(), id});
        }
    }

    public static void register(TileBlock block, Class<? extends ModTileEntity> tileEntity, Class<? extends TileContainer> container, String dspName) {
        TileBlockEntry entry = new TileBlockEntry(block);
        entry.tileEntity = tileEntity;
        GameRegistry.registerTileEntity(tileEntity, (String)block.func_149739_a());
        entry.container = container;
        LanguageRegistry.addName((Object)((Object)block), (String)dspName);
        registry.put(block, entry);
    }

    public static TileBlockEntry getBlockEntry(Block b) {
        return registry.get(b);
    }

    public static class TileBlockEntry {
        public final TileBlock block;
        public Class<? extends ModTileEntity> tileEntity;
        public Class<? extends TileContainer> container;
        @SideOnly(value=Side.CLIENT)
        public Class<? extends GuiContainer> gui;

        public TileBlockEntry(TileBlock block) {
            this.block = block;
        }
    }
}

