/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.DefaultBlock;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBlock
extends DefaultBlock
implements ITileEntityProvider {
    public static final int[] TypeTexAm = new int[]{1, 2, 3, 4, 2, 2, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    public int machineId;
    public boolean registered;
    private byte type;
    private boolean redstone;
    private boolean opaque;
    private int renderType;
    private boolean drop;

    public TileBlock(String id, Material m, Class<? extends ItemBlock> item, int type, String ... tex) {
        super(id, m, item, TileBlock.getTextureNames(id, type, tex));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.type = (byte)(type & 0xF);
        this.redstone = (type & 0x10) != 0;
        this.opaque = (type & 0x20) == 0;
        this.drop = (type & 0x40) == 0;
        this.renderType = 0;
    }

    private static String[] getTextureNames(String id, int type, String[] tex) {
        if (tex != null && tex.length > 0) {
            return tex;
        }
        int n = TypeTexAm[type & 0xF];
        tex = new String[n];
        for (int i = 0; i < n; ++i) {
            tex[i] = id.concat(Integer.toHexString(i));
        }
        return tex;
    }

    @Override
    public IIcon getIconN(int n) {
        if (this.addTextures == null || n <= 0 || n > this.addTextures.length) {
            return this.field_149761_L;
        }
        return this.addTextures[n - 1];
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(this.field_149768_d);
        if (this.addTexNames != null) {
            this.addTextures = new IIcon[this.addTexNames.length];
            for (int i = 0; i < this.addTextures.length; ++i) {
                this.addTextures[i] = register.func_94245_a(this.addTexNames[i]);
            }
        }
    }

    public TileEntity func_149915_a(World world, int id) {
        TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(this);
        if (entry != null && entry.tileEntity != null) {
            try {
                return entry.tileEntity.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int s, float X, float Y, float Z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).onActivated(player, s, X, Y, Z);
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onClicked(player);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborBlockChange(b);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborTileChange(tileX, tileY, tileZ);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int a) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).breakBlock();
        }
        super.func_149749_a(world, x, y, z, b, a);
    }

    public boolean func_149744_f() {
        return this.redstone;
    }

    public boolean func_149721_r() {
        if (this.opaque) {
            return super.func_149721_r();
        }
        if (!super.func_149721_r()) {
            return false;
        }
        return this.field_149755_E == 1.0 && this.field_149759_B == 0.0 && this.field_149756_F == 1.0 && this.field_149760_C == 0.0 && this.field_149757_G == 1.0 && this.field_149754_D == 0.0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return super.isNormalCube(world, x, y, z);
    }

    public IIcon func_149691_a(int s, int m) {
        return this.getIconN(this.getTextureIdx(s, m));
    }

    protected int getTextureIdx(int s, int m) {
        if (this.type == 0) {
            return 0;
        }
        if (this.type == 1) {
            return s < 2 ? 0 : 1;
        }
        if (this.type == 2) {
            return s == 1 ? 0 : (s == 0 ? 1 : 2);
        }
        if (this.type == 3) {
            if (m == 0) {
                m = 3;
            }
            return s == 1 ? 0 : (s == 0 ? 1 : (s == m ? 2 : 3));
        }
        if (this.type == 4 || this.type == 5) {
            return s == m ? 0 : 1;
        }
        if (this.type == 6) {
            return s == m ? 0 : ((s ^ 1) == m ? 1 : 2);
        }
        return s;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s ^ 1, true);
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s ^ 1, false);
        }
        return 0;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        TileEntity te;
        if (!(this.type <= 2 || this.type >= 7 || entity.func_70093_af() && this.type >= 5)) {
            int s = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int m = 0;
            if (s == 0) {
                m = 2;
            } else if (s == 1) {
                m = 5;
            } else if (s == 2) {
                m = 3;
            } else if (s == 3) {
                m = 4;
            }
            if (this.type == 5 || this.type == 6) {
                if (entity.field_70125_A > 40.0f) {
                    m = 1;
                } else if (entity.field_70125_A < -35.0f) {
                    m = 0;
                }
            }
            world.func_72921_c(x, y, z, m, 3);
        }
        if ((te = world.func_147438_o(x, y, z)) != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onPlaced(entity, item);
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int s, float X, float Y, float Z, int m) {
        return this.type == 5 || this.type == 6 ? s ^ 1 : m;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onEntityCollided(entity);
        }
    }

    public boolean func_149662_c() {
        return this.opaque;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void setRenderType(int t) {
        this.renderType = t;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public void func_149681_a(World par1World, int x, int y, int z, int par5, EntityPlayer par6EntityPlayer) {
        if (!this.drop) {
            super.func_149636_a(par1World, par6EntityPlayer, x, y, z, par5);
        }
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        if (this.drop) {
            super.func_149636_a(par1World, par2EntityPlayer, par3, par4, par5, par6);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.drop) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).dropItem(metadata, fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }
}

