/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.computers;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.lang.reflect.Method;
import li.cil.oc.api.API;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")
public class ComputerAPI
implements IPeripheralProvider {
    private static boolean registered = false;
    public static final ComputerAPI instance = new ComputerAPI();
    public static Class CCcomp;
    public static Class CCapi;
    public static Class CCperProv;
    public static Class OCcomp;
    public static Method CCevent;
    public static Method OCevent;

    public static void register() {
        if (registered) {
            return;
        }
        try {
            CCapi = Class.forName("dan200.computercraft.api.ComputerCraftAPI");
            CCcomp = Class.forName("dan200.computercraft.api.peripheral.IComputerAccess");
            CCperProv = Class.forName("dan200.computercraft.api.peripheral.IPeripheralProvider");
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"ComputerCraft API found", (Object[])new Object[0]);
        }
        catch (ClassNotFoundException e) {
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"ComputerCraft API not available!", (Object[])new Object[0]);
            CCapi = null;
            CCcomp = null;
            CCperProv = null;
        }
        if (CCapi != null) {
            try {
                CCapi.getMethod("registerPeripheralProvider", CCperProv).invoke(null, instance);
                CCevent = CCcomp.getMethod("queueEvent", String.class, Object[].class);
            }
            catch (Exception e) {
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.ERROR, (Throwable)e, (String)"can't get API methods:", (Object[])new Object[0]);
            }
        }
        try {
            OCcomp = Class.forName("li.cil.oc.api.machine.Context");
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"OpenComputers API found", (Object[])new Object[0]);
        }
        catch (ClassNotFoundException e) {
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"OpenComputers API not available!", (Object[])new Object[0]);
        }
        if (OCcomp != null) {
            try {
                OCevent = OCcomp.getMethod("signal", String.class, Object[].class);
            }
            catch (Exception e) {
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.ERROR, (Throwable)e, (String)"can't get API methods:", (Object[])new Object[0]);
            }
        }
        registered = true;
    }

    public static void sendEvent(Object obj, String name, Object ... args) {
        if (obj == null) {
            return;
        }
        try {
            if (OCcomp.isInstance(obj)) {
                OCevent.invoke(obj, name, args);
            } else if (CCcomp.isInstance(obj)) {
                CCevent.invoke(obj, name, args);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"can't send event to computer!", (Object[])new Object[0]);
        }
    }

    public static Object newOCnode(TileEntity tile, String name, boolean power) {
        return tile instanceof Environment && API.network != null ? (power ? (Component)API.network.newNode((Environment)tile, Visibility.Network).withComponent(name).withConnector().create() : (Component)API.network.newNode((Environment)tile, Visibility.Network).withComponent(name).create()) : null;
    }

    public static double update(TileEntity tile, Object node, double energy) {
        if (node == null || !(node instanceof Component)) {
            return 0.0;
        }
        if (((Component)node).network() == null) {
            Network.joinOrCreateNetwork(tile);
        }
        if (node instanceof ComponentConnector) {
            return energy - ((ComponentConnector)node).changeBuffer(energy * 0.001) * 1000.0;
        }
        return 0.0;
    }

    public static void removeOCnode(Object node) {
        if (node != null) {
            ((Node)node).remove();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int s) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPeripheral) {
            return (IPeripheral)te;
        }
        return null;
    }
}

