/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.circuits;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneHandler {
    public static boolean get1bitState(TileEntity te, boolean useRst) {
        if (te == null || !(te instanceof IRedstone1bit)) {
            return false;
        }
        IRedstone1bit rs = (IRedstone1bit)te;
        for (int i = 0; i < 6; ++i) {
            if (rs.getBitDirection(i) >= 0) continue;
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            TileEntity tile = te.func_145831_w().func_147438_o(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ);
            if (tile != null && tile instanceof IRedstone1bit && ((IRedstone1bit)tile).getBitDirection(i ^ 1) > 0 && ((IRedstone1bit)tile).getBitValue(i ^ 1)) {
                return true;
            }
            if (!useRst || !te.func_145831_w().func_94574_k(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ, i)) continue;
            return true;
        }
        return false;
    }

    public static byte get8bitState(TileEntity te) {
        if (te == null || !(te instanceof IRedstone8bit)) {
            return 0;
        }
        IRedstone8bit rs = (IRedstone8bit)te;
        byte state = 0;
        for (int i = 0; i < 6 && state != -1; ++i) {
            if (rs.getDirection(i) >= 0) continue;
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            TileEntity tile = te.func_145831_w().func_147438_o(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ);
            if (tile == null || !(tile instanceof IRedstone8bit) || ((IRedstone8bit)tile).getDirection(i ^ 1) <= 0) continue;
            state = (byte)(state | ((IRedstone8bit)tile).getValue(i ^ 1));
        }
        return state;
    }

    public static void notify1bitNeighbors(TileEntity te, boolean s, int rec, boolean useRst) {
        if (te == null || !(te instanceof IRedstone1bit)) {
            return;
        }
        IRedstone1bit rs = (IRedstone1bit)te;
        for (int i = 0; i < 6; ++i) {
            if (rs.getBitDirection(i) <= 0) continue;
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            TileEntity tile = te.func_145831_w().func_147438_o(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ);
            if (tile != null && tile instanceof IRedstone1bit && ((IRedstone1bit)tile).getBitDirection(i ^ 1) < 0) {
                ((IRedstone1bit)tile).setBitValue(i ^ 1, s, rec);
                continue;
            }
            if (!useRst) continue;
            te.func_145831_w().func_147460_e(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ, te.func_145838_q());
            te.func_145831_w().func_147459_d(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ, te.func_145838_q());
        }
    }

    public static void notify8bitNeighbors(TileEntity te, byte s, int rec) {
        if (te == null || !(te instanceof IRedstone8bit)) {
            return;
        }
        IRedstone8bit rs = (IRedstone8bit)te;
        for (int i = 0; i < 6; ++i) {
            if (rs.getDirection(i) <= 0) continue;
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            TileEntity tile = te.func_145831_w().func_147438_o(te.field_145851_c + d.offsetX, te.field_145848_d + d.offsetY, te.field_145849_e + d.offsetZ);
            if (tile == null || !(tile instanceof IRedstone8bit) || ((IRedstone8bit)tile).getDirection(i ^ 1) >= 0) continue;
            ((IRedstone8bit)tile).setValue(i ^ 1, s, rec);
        }
    }
}

