/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.api.automation.IEnergy;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PipeEnergy {
    public static final PipeEnergy empty = new PipeEnergy(0, 0.0f);
    public boolean update;
    public byte con = 0;
    public double Ucap = 0.0;
    public double[] Iind = new double[]{0.0, 0.0, 0.0};
    public final int Umax;
    public final float Rcond;

    public PipeEnergy(int Umax, float Rcond) {
        this.Umax = Umax;
        this.Rcond = Rcond;
    }

    public PipeEnergy connect(byte c) {
        this.con = c;
        return this;
    }

    public void addEnergy(double E) {
        this.Ucap = Math.sqrt(this.Ucap * this.Ucap + E);
        if (Double.isNaN(this.Ucap)) {
            this.Ucap = 0.0;
        }
    }

    public double getEnergy(double U, double R) {
        if (R < 1.0) {
            R = 1.0;
        }
        return (this.Ucap * this.Ucap - U * U) / R;
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.con = nbt.func_74771_c("con");
        this.Ucap = nbt.func_74769_h(name.concat("Ucap"));
        this.Iind[0] = nbt.func_74769_h(name.concat("IindY"));
        this.Iind[1] = nbt.func_74769_h(name.concat("IindZ"));
        this.Iind[2] = nbt.func_74769_h(name.concat("IindX"));
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74774_a("con", this.con);
        nbt.func_74780_a(name.concat("Ucap"), this.Ucap);
        nbt.func_74780_a(name.concat("IindY"), this.Iind[0]);
        nbt.func_74780_a(name.concat("IindZ"), this.Iind[1]);
        nbt.func_74780_a(name.concat("IindX"), this.Iind[2]);
    }

    public boolean isConnected(int s) {
        return (this.con >> s & 1) == 0;
    }

    public void update(ModTileEntity tile) {
        if (!(tile instanceof IEnergy)) {
            return;
        }
        IEnergy src = (IEnergy)((Object)tile);
        for (int i = 0; i < this.Iind.length; ++i) {
            PipeEnergy energy;
            int s = i << 1;
            if (src.getEnergy((byte)s) != this || !this.isConnected(s)) continue;
            TileEntity te = Utils.getTileOnSide(tile, (byte)s);
            PipeEnergy pipeEnergy = energy = te != null && te instanceof IEnergy ? ((IEnergy)te).getEnergy((byte)(s | 1)) : null;
            if (energy == null || energy.Umax <= 0 || !energy.isConnected(s | 1)) continue;
            double uc = energy.Ucap;
            double ii = (this.Ucap - uc) / (1.0 + (double)this.Rcond);
            double ud = (ii + this.Iind[i] * (1.0 - (double)this.Rcond)) / 2.0;
            this.Ucap -= ud;
            energy.Ucap += ud;
            this.Iind[i] = ii;
        }
        if (this.Ucap > (double)this.Umax) {
            this.Ucap = this.Umax;
        }
    }

    public static String[] getEnergyInfo(float U1, float U0, float R) {
        float I = (U1 - U0) / R;
        float P = (U1 + U0) * I;
        return new String[]{"Power:", String.format("%.1f kW", Float.valueOf(P / 1000.0f)), String.format("@ %.0f A", Float.valueOf(I))};
    }
}

