/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyItemHandler {
    public static void addInformation(ItemStack item, List list) {
        if (EnergyItemHandler.isEnergyItem(item)) {
            list.add(String.format("Energy: %d / %d kJ", EnergyItemHandler.getEnergy(item), ((IEnergyItem)item.func_77973_b()).getEnergyCap(item)));
        }
    }

    public static int getEnergy(ItemStack item) {
        if (item != null && item.func_77973_b() instanceof IEnergyItem) {
            IEnergyItem ei = (IEnergyItem)item.func_77973_b();
            String tag = ei.getEnergyTag(item);
            EnergyItemHandler.createNBT(item, tag);
            return item.field_77990_d.func_74762_e(tag);
        }
        return 0;
    }

    public static int addEnergy(ItemStack item, int n, boolean restrict) {
        if (item != null && item.func_77973_b() instanceof IEnergyItem && item.field_77994_a == 1) {
            int r;
            int s;
            int e;
            IEnergyItem ei = (IEnergyItem)item.func_77973_b();
            String tag = ei.getEnergyTag(item);
            int cap = ei.getEnergyCap(item);
            EnergyItemHandler.createNBT(item, tag);
            if (restrict) {
                int max = ei.getChargeSpeed(item);
                if (n > max) {
                    n = max;
                } else if (n < -max) {
                    n = -max;
                }
            }
            if ((e = item.field_77990_d.func_74762_e(tag) + n) < 0) {
                s = 0;
                r = n - e;
            } else if (e > cap) {
                s = cap;
                r = n - e + cap;
            } else {
                s = e;
                r = n;
            }
            item.field_77990_d.func_74768_a(tag, s);
            int d = item.func_77958_k();
            item.func_77964_b(d - s * d / cap);
            return r;
        }
        return 0;
    }

    public static boolean isEnergyItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IEnergyItem;
    }

    private static void createNBT(ItemStack item, String tag) {
        if (item.field_77990_d == null) {
            item.field_77990_d = new NBTTagCompound();
        }
        if (!item.field_77990_d.func_74764_b(tag)) {
            item.field_77990_d.func_74768_a(tag, 0);
        }
    }

    public static interface IEnergyItem {
        public int getEnergyCap(ItemStack var1);

        public int getChargeSpeed(ItemStack var1);

        public String getEnergyTag(ItemStack var1);
    }
}

