/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.api.automation.IAreaConfig;
import cd4017be.api.automation.ProtectLvl;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class AreaProtect
implements ForgeChunkManager.LoadingCallback {
    public static byte permissions = 1;
    public static byte chunkloadPerm = 1;
    public static byte maxChunksPBlock = (byte)24;
    public static AreaProtect instance = new AreaProtect();
    private static boolean registered = false;
    private static Object mod;
    public HashMap<Integer, ArrayList<IAreaConfig>> loadedSS = new HashMap();
    public HashMap<Integer, ArrayList<ForgeChunkManager.Ticket>> usedTickets = new HashMap();

    public static void register(Object mod) {
        if (!registered) {
            AreaProtect.mod = mod;
            MinecraftForge.EVENT_BUS.register((Object)instance);
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)instance);
        }
        registered = true;
    }

    @SubscribeEvent
    public void handlePlayerInteract(PlayerInteractEvent event) {
        ProtectLvl pl;
        if (permissions < 0) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            ProtectLvl pl2 = this.getPlayerAccess(event.entityPlayer.func_70005_c_(), event.entityPlayer.field_70170_p, event.x >> 4, event.z >> 4);
            if (pl2 != ProtectLvl.Free && (pl2 != ProtectLvl.Protected || event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || event.entityPlayer.func_71045_bC() != null)) {
                event.setCanceled(true);
            }
        } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && (pl = this.getPlayerAccess(event.entityPlayer.func_70005_c_(), event.entityPlayer.field_70170_p, (int)Math.floor(event.entityPlayer.field_70165_t) >> 4, (int)Math.floor(event.entityPlayer.field_70161_v) >> 4)) != ProtectLvl.Free && pl != ProtectLvl.Protected) {
            event.setCanceled(true);
        }
    }

    public ProtectLvl getPlayerAccess(String name, World world, int chunkX, int chunkZ) {
        if (permissions < 0) {
            return ProtectLvl.Free;
        }
        int ac = 0;
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.field_76574_g);
        if (list == null) {
            return ProtectLvl.Free;
        }
        for (IAreaConfig cfg : list) {
            ac = Math.max(ac, cfg.getProtectLvlFor(name, chunkX, chunkZ));
        }
        return ProtectLvl.getLvl(ac);
    }

    public boolean isOperationAllowed(String player, World world, int cx, int cz) {
        if (permissions < 0) {
            return true;
        }
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.field_76574_g);
        if (list == null) {
            return true;
        }
        for (IAreaConfig cfg : list) {
            if (cfg.getProtectLvlFor(player, cx, cz) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isOperationAllowed(String player, World world, int x0, int x1, int z0, int z1) {
        if (permissions < 0) {
            return true;
        }
        for (int cx = x0 >> 4; cx < x1 >> 4; ++cx) {
            for (int cz = z0 >> 4; cz < z1 >> 4; ++cz) {
                if (this.isOperationAllowed(player, world, cx, cz)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isInteractingAllowed(String player, World world, int cx, int cz) {
        if (permissions < 0) {
            return true;
        }
        ArrayList<IAreaConfig> list = this.loadedSS.get(world.field_73011_w.field_76574_g);
        if (list == null) {
            return true;
        }
        for (IAreaConfig cfg : list) {
            if (cfg.getProtectLvlFor(player, cx, cz) <= 1) continue;
            return false;
        }
        return true;
    }

    public void loadSecuritySys(IAreaConfig config) {
        int[] pos = config.getPosition();
        ArrayList<IAreaConfig> list = this.loadedSS.get(pos[3]);
        if (list == null) {
            list = new ArrayList();
            this.loadedSS.put(pos[3], list);
        }
        list.add(config);
        ArrayList<ForgeChunkManager.Ticket> tickets = this.usedTickets.get(pos[3]);
        if (tickets != null) {
            for (ForgeChunkManager.Ticket t : tickets) {
                NBTTagCompound tag = t.getModData();
                if (tag.func_74762_e("bx") != pos[0] || tag.func_74762_e("by") != pos[1] || tag.func_74762_e("bz") != pos[2]) continue;
                config.setTicket(t);
                break;
            }
        }
    }

    public void removeChunkLoader(IAreaConfig config) {
        int d = config.getPosition()[3];
        ArrayList<ForgeChunkManager.Ticket> list = this.usedTickets.get(d);
        ForgeChunkManager.Ticket t = config.getTicket();
        if (t != null) {
            config.setTicket(null);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.usedTickets.remove(d);
                }
            }
        }
    }

    public void supplyTicket(IAreaConfig config, World world) {
        ForgeChunkManager.Ticket t;
        NBTTagCompound tag;
        int[] p = config.getPosition();
        ArrayList<ForgeChunkManager.Ticket> list = this.usedTickets.get(p[3]);
        if (list != null) {
            for (ForgeChunkManager.Ticket t2 : list) {
                tag = t2.getModData();
                if (tag.func_74762_e("bx") != p[0] || tag.func_74762_e("by") != p[1] || tag.func_74762_e("bz") != p[2]) continue;
                config.setTicket(t2);
                return;
            }
        }
        if ((t = ForgeChunkManager.requestTicket((Object)mod, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) == null) {
            return;
        }
        tag = t.getModData();
        tag.func_74768_a("bx", p[0]);
        tag.func_74768_a("by", p[1]);
        tag.func_74768_a("bz", p[2]);
        t.setChunkListDepth((int)maxChunksPBlock);
        config.setTicket(t);
    }

    public void unloadSecuritySys(IAreaConfig config) {
        int d = config.getPosition()[3];
        ArrayList<IAreaConfig> list = this.loadedSS.get(d);
        if (list != null) {
            list.remove(config);
            if (list.isEmpty()) {
                this.loadedSS.remove(d);
            }
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        ArrayList<Object> list = this.usedTickets.get(world.field_73011_w.field_76574_g);
        if (list == null) {
            list = new ArrayList();
            this.usedTickets.put(world.field_73011_w.field_76574_g, list);
        }
        list.addAll(tickets);
    }
}

