#if COLOR_PRESET == 0
#include "/lib/color/data/data1.glsl"
#elif COLOR_PRESET == 1
#include "/lib/color/data/data2.glsl"
#elif COLOR_PRESET == 3
#include "/lib/color/data/data3.glsl"
#endif
vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = ((DENSITY -rainStrength*4000.0)*(0.4+sunVisibility*0.6));
	/*--------------------------------*/
	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	float d = length(fposition);
	float height = mix(getAirDensity (worldpos.y),0.1,rainStrength*0.8);
	/*--------------------------------*/
	float fog = clamp(20.0*exp(-getAirDensity (cameraPosition.y)/density) *(1.0-exp( -d*height/density )) /height-.3+rainStrength*0.25,0.0,0.1);
	/*--------------------------------*/
return  mix(color,normalize(fogclr)*mix(pow(length(fogclr),3.33)*vec3(RFOG,GFOG,BFOG),pow(length(fogclr),0.1)*vec3(0.05),max(moonVisibility*(1.0-sunVisibility),rainStrength)),fog);	
}