/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends agr<ri>
implements aho,
cc,
AutoCloseable,
Runnable {
    private static final Logger h = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final bhq c = new bhq("North Carolina".hashCode(), bhj.b, true, false, bht.b).a();
    private final coj i;
    private final ahn j = new ahn("server", this, p.b());
    private final File k;
    private final List<Runnable> l = Lists.newArrayList();
    private final agg m = new agg(this::ai);
    private final vz n;
    protected final vs d;
    private final qd o = new qd();
    private final Random p = new Random();
    private final DataFixer q;
    private String r;
    private int s = -1;
    private final Map<byi, vi> t = Maps.newIdentityHashMap();
    private xt u;
    private volatile boolean v = true;
    private boolean w;
    private int x;
    protected final Proxy e;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    @Nullable
    private String E;
    private int F;
    private int G;
    public final long[] f = new long[100];
    @Nullable
    private KeyPair H;
    @Nullable
    private String I;
    private final String J;
    @Nullable
    private String K;
    private boolean L;
    private boolean M;
    private String N = "";
    private String O = "";
    private volatile boolean P;
    private long Q;
    @Nullable
    private jn R;
    private boolean S;
    private boolean T;
    @Nullable
    private final YggdrasilAuthenticationService U;
    private final MinecraftSessionService V;
    private final GameProfileRepository W;
    private final xp X;
    private long Y;
    protected final Thread g = p.a(new Thread((Runnable)this, "Server thread"), (T thread2) -> thread2.setUncaughtExceptionHandler((thread, throwable) -> h.error((Object)throwable)));
    private long Z = p.b();
    private long aa;
    private boolean ab;
    private boolean ac;
    private final xe ad = new xl(wk.b, this.g);
    private final wv<wy> ae = new wv<wy>(wy::new);
    @Nullable
    private wt af;
    private final ce ag;
    private final ben ah = new ben();
    private final zg ai = new zg();
    private final rh aj = new rh(this);
    private final rk ak = new rk(this);
    private final cox al = new cox();
    private final re am = new re();
    private final rf an = new rf(this);
    private final zo ao = new zo();
    private boolean ap;
    private boolean aq;
    private boolean ar;
    private float as;
    private final Executor at;
    @Nullable
    private String au;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, ce ce2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, xp xp2, vs vs2, String string) {
        super("Server");
        this.e = proxy;
        this.ag = ce2;
        this.U = yggdrasilAuthenticationService;
        this.V = minecraftSessionService;
        this.W = gameProfileRepository;
        this.X = xp2;
        this.k = file;
        this.n = new vz(this);
        this.d = vs2;
        this.i = new coj(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.q = dataFixer;
        this.ad.a(this.ai);
        this.ad.a(this.ah);
        this.ad.a(this.al);
        this.ad.a(this.an);
        this.ad.a(this.am);
        this.at = p.e();
        this.J = string;
    }

    @Override
    private void a(cof cof2) {
        ctc ctc2 = cof2.a(ctc::new, "scoreboard");
        ctc2.a(this.aL());
        this.aL().a(new cnv(ctc2));
    }

    protected abstract boolean d() throws IOException;

    @Override
    protected void a(String string) {
        if (this.N().a(string)) {
            h.info("Converting map!");
            this.b(new jx("menu.convertingLevel", new Object[0]));
            this.N().a(string, new zw(){
                private long b = p.b();

                @Override
                public void a(jn jn2) {
                }

                @Override
                public void b(jn jn2) {
                }

                @Override
                public void a(int n2) {
                    if (p.b() - this.b >= 1000L) {
                        this.b = p.b();
                        h.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(jn jn2) {
                }
            });
        }
        if (this.aq) {
            h.info("Forcing world upgrade!");
            cog cog2 = this.N().b(this.J());
            if (cog2 != null) {
                agu agu2 = new agu(this.J(), this.N(), cog2, this.ar);
                jn \u26032 = null;
                while (!agu2.b()) {
                    jn jn2 = agu2.g();
                    if (\u26032 != jn2) {
                        \u26032 = jn2;
                        h.info(agu2.g().getString());
                    }
                    if ((\u2603 = agu2.d()) > 0) {
                        int n2 = agu2.e() + agu2.f();
                        h.info("{}% completed ({} / {} chunks)...", (Object)zv.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ac()) {
                        agu2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(jn jn2) {
        this.R = jn2;
    }

    protected void a(String string, String string2, long l22, bht bht2, JsonElement jsonElement) {
        bhq \u26033;
        this.a(string);
        this.b(new jx("menu.loadingLevel", new Object[0]));
        coh coh2 = this.N().a(string, this);
        this.a(this.J(), coh2);
        cog \u26032 = coh2.c();
        if (\u26032 == null) {
            if (this.M()) {
                \u26033 = c;
            } else {
                long l22;
                \u26033 = new bhq(l22, this.g(), this.f(), this.i(), bht2);
                \u26033.a(jsonElement);
                if (this.M) {
                    \u26033.a();
                }
            }
            \u26032 = new cog(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new bhq(\u26032);
        }
        this.a(coh2.a(), \u26032);
        vr vr2 = this.d.create(11);
        this.a(coh2, \u26032, \u26033, vr2);
        this.a(this.h(), true);
        this.a(vr2);
    }

    protected void a(coh coh2, cog cog22, bhq bhq2, vr vr2) {
        vi vi2;
        if (this.M()) {
            cog22.a(c);
        }
        vi vi3 = new vi(this, this.at, coh2, cog22, byi.a, this.m, vr2);
        this.t.put(byi.a, vi3);
        this.a(vi3.x());
        vi3.q_().b(cog22);
        vi2 = this.a(byi.a);
        if (!cog22.u()) {
            cog cog22;
            try {
                vi2.a(bhq2);
                if (cog22.s() == bht.h) {
                    this.a(cog22);
                }
                cog22.d(true);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception initializing level");
                try {
                    vi2.a(d2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new m(d2);
            }
            cog22.d(true);
        }
        this.ad().a(vi2);
        if (cog22.P() != null) {
            this.aO().a(cog22.P());
        }
        for (byi byi2 : byi.a()) {
            if (byi2 == byi.a) continue;
            this.t.put(byi2, new va(vi2, this, this.at, coh2, byi2, (agk)this.m, vr2));
        }
    }

    @Override
    private void a(cog cog2) {
        cog2.f(false);
        cog2.c(true);
        cog2.b(false);
        cog2.a(false);
        cog2.g(1000000000);
        cog2.b(6000L);
        cog2.a(bhj.e);
        cog2.g(false);
        cog2.a(ahd.a);
        cog2.e(true);
        cog2.v().a(bhi.j).a(false, this);
    }

    protected void a(File file, cog cog2) {
        this.ae.a(new wx());
        this.af = new wt(new File(file, "datapacks"));
        this.ae.a(this.af);
        this.ae.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : cog2.O()) {
            wy wy2 = this.ae.a(string);
            if (wy2 != null) {
                arrayList.add(wy2);
                continue;
            }
            h.warn("Missing data pack {}", (Object)string);
        }
        this.ae.a(arrayList);
        this.b(cog2);
    }

    @Override
    protected void a(vr vr2) {
        this.b(new jx("menu.generatingTerrain", new Object[0]));
        vi vi2 = this.a(byi.a);
        h.info("Preparing start region for dimension " + byi.a(vi2.q.p()));
        ev \u26032 = vi2.o_();
        vr2.a(new bgy(\u26032));
        vg \u26033 = vi2.m();
        \u26033.a().a(500);
        this.Z = p.b();
        \u26033.a(vn.a, new bgy(\u26032), 11, aad.a);
        while (\u26033.b() != 441) {
            this.Z = p.b() + 10L;
            this.o();
        }
        this.Z = p.b() + 10L;
        this.o();
        for (byi byi2 : byi.a()) {
            bhh bhh2 = this.a(byi2).x().b(bhh::new, "chunks");
            if (bhh2 == null) continue;
            vi \u26034 = this.a(byi2);
            LongIterator \u26035 = bhh2.a().iterator();
            while (\u26035.hasNext()) {
                long l2 = \u26035.nextLong();
                bgy \u26036 = new bgy(l2);
                \u26034.m().a(\u26036, true);
            }
        }
        this.Z = p.b() + 10L;
        this.o();
        vr2.b();
        \u26033.a().a(5);
    }

    protected void a(String string, coh coh2) {
        File file = new File(coh2.a(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean f();

    public abstract bhj g();

    public abstract ahd h();

    public abstract boolean i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (vi vi2 : this.x()) {
            if (!bl2) {
                h.info("Saving chunks for level '{}'/{}", (Object)vi2.p_().i(), (Object)byi.a(vi2.q.p()));
            }
            try {
                vi2.a(null, bl3, vi2.b && !bl4);
            }
            catch (bho bho2) {
                h.warn(bho2.getMessage());
            }
            bl5 = true;
        }
        vi vi2 = this.a(byi.a);
        cog cog2 = vi2.p_();
        vi2.q_().a(cog2);
        cog2.c(this.aO().c());
        vi2.w().a(cog2, this.ad().r());
        return bl5;
    }

    @Override
    public void close() {
        this.l();
    }

    protected void l() {
        h.info("Stopping server");
        if (this.af() != null) {
            this.af().b();
        }
        if (this.u != null) {
            h.info("Saving players");
            this.u.i();
            this.u.s();
        }
        h.info("Saving worlds");
        for (vi vi2 : this.x()) {
            if (vi2 == null) continue;
            vi2.b = false;
        }
        this.a(false, true, false);
        for (vi vi2 : this.x()) {
            if (vi2 == null) continue;
            try {
                vi2.close();
            }
            catch (IOException iOException) {
                h.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.j.d()) {
            this.j.e();
        }
    }

    public String m() {
        return this.r;
    }

    public void b(String string) {
        this.r = string;
    }

    public boolean h_() {
        return this.v;
    }

    @Override
    public void a(boolean bl2) {
        this.v = false;
        if (bl2) {
            try {
                this.g.join();
            }
            catch (InterruptedException interruptedException) {
                h.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.Z = p.b();
                this.o.a(new jw(this.E));
                this.o.a(new qd.c(o.a().getName(), o.a().getProtocolVersion()));
                this.a(this.o);
                while (this.v) {
                    long l2 = p.b() - this.Z;
                    if (l2 > 2000L && this.Z - this.Q >= 15000L) {
                        \u2603 = l2 / 50L;
                        h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.Z += \u2603 * 50L;
                        this.Q = this.Z;
                    }
                    this.Z += 50L;
                    if (this.S) {
                        this.S = false;
                        this.m.d().d();
                    }
                    this.m.a();
                    this.m.a("tick");
                    this.a(this::aV);
                    this.m.b("nextTickWait");
                    this.ab = true;
                    this.aa = Math.max(p.b() + 50L, this.Z);
                    this.o();
                    this.m.c();
                    this.m.b();
                    this.P = true;
                }
            } else {
                this.a((d)null);
            }
        }
        catch (Throwable throwable) {
            h.error("Encountered an unexpected exception", throwable);
            d d2 = throwable instanceof m ? this.b(((m)throwable).a()) : this.b(new d("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.s(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (d2.a(\u26032)) {
                h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(d2);
        }
        finally {
            try {
                this.w = true;
                this.l();
            }
            catch (Throwable \u26033) {
                h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.t();
            }
        }
    }

    private boolean aV() {
        return this.bg() || p.b() < (this.ab ? this.aa : this.Z);
    }

    protected void o() {
        this.bf();
        this.c(() -> !this.aV());
    }

    protected ri a(Runnable runnable) {
        return new ri(this.x, runnable);
    }

    protected boolean a(ri ri2) {
        return ri2.a() + 3 < this.x || this.aV();
    }

    @Override
    public boolean p() {
        boolean bl2;
        this.ab = bl2 = this.aW();
        return bl2;
    }

    private boolean aW() {
        if (super.p()) {
            return true;
        }
        if (this.aV()) {
            for (vi vi2 : this.x()) {
                if (!vi2.m().d()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(qd qd2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.N().b(this.J(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                qd2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean q() {
        this.ac = this.ac || this.r().isFile();
        return this.ac;
    }

    public File r() {
        return this.N().b(this.J(), "icon.png");
    }

    public File s() {
        return new File(".");
    }

    @Override
    protected void a(d d2) {
    }

    protected void t() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = p.c();
        ++this.x;
        this.b(booleanSupplier);
        if (l2 - this.Y >= 5000000000L) {
            this.Y = l2;
            this.o.a(new qd.a(this.A(), this.z()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.z(), 12)];
            int \u26032 = zv.a(this.p, 0, this.z() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.u.t().get(\u26032 + i2).dI();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.o.b().a(gameProfileArray);
        }
        if (this.x % 6000 == 0) {
            h.debug("Autosave started");
            this.m.a("save");
            this.u.i();
            this.a(true, false, false);
            this.m.c();
            h.debug("Autosave finished");
        }
        this.m.a("snooper");
        if (!this.j.d() && this.x > 100) {
            this.j.a();
        }
        if (this.x % 6000 == 0) {
            this.j.b();
        }
        this.m.c();
        this.m.a("tallying");
        long l3 = p.c() - l2;
        this.f[this.x % 100] = l3;
        \u2603 = l3;
        this.as = this.as * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = p.c();
        this.ao.a(\u2603 - l2);
        this.m.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.m.a("commandFunctions");
        this.aC().e();
        this.m.b("levels");
        for (vi vi2 : this.x()) {
            if (vi2.q.p() != byi.a && !this.u()) continue;
            this.m.a(() -> vi2.p_().i() + " " + fm.x.b(vi2.q.p()));
            if (this.x % 20 == 0) {
                this.m.a("timeSync");
                this.u.a(new nc(vi2.R(), vi2.S(), vi2.T().b(bhi.j)), vi2.q.p());
                this.m.c();
            }
            this.m.a("tick");
            try {
                vi2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception ticking world");
                vi2.a(d2);
                throw new m(d2);
            }
            this.m.c();
            this.m.c();
        }
        this.m.b("connection");
        this.af().c();
        this.m.b("players");
        this.u.d();
        this.m.b("server gui refresh");
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.l.get(i2).run();
        }
        this.m.c();
    }

    public boolean u() {
        return true;
    }

    public void b(Runnable runnable) {
        this.l.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            uk \u260316 = new uk(\u260315);
            \u260316.b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            ra \u260318 = new ra(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                h.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.a()) {
                h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            qv.a();
            qv.c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            xp \u260323 = new xp(\u260322, new File(\u260319, b.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.a().o);
            final ui \u260325 = new ui(new File(\u260319), \u260316, aah.a(), \u260320, \u260321, \u260322, \u260323, vt::new, \u260324);
            \u260325.i((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.a((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.e(optionSet.has((OptionSpec)\u26034));
            \u260325.f(optionSet.has((OptionSpec)\u26035));
            \u260325.b(optionSet.has((OptionSpec)\u26036));
            \u260325.c(optionSet.has((OptionSpec)\u26037));
            \u260325.c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl2 = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.aY();
            }
            \u260325.v();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.a(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new g(h));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void c(String string) {
        this.au = string;
    }

    protected void b(boolean bl2) {
        this.aq = bl2;
    }

    protected void c(boolean bl2) {
        this.ar = bl2;
    }

    public void v() {
        this.g.start();
    }

    public boolean w() {
        return !this.g.isAlive();
    }

    public File d(String string) {
        return new File(this.s(), string);
    }

    public void e(String string) {
        h.info(string);
    }

    public void f(String string) {
        h.warn(string);
    }

    public vi a(byi byi2) {
        return this.t.get(byi2);
    }

    public Iterable<vi> x() {
        return this.t.values();
    }

    public String y() {
        return o.a().getName();
    }

    public int z() {
        return this.u.n();
    }

    public int A() {
        return this.u.o();
    }

    public String[] B() {
        return this.u.e();
    }

    public boolean D() {
        return false;
    }

    @Override
    public void g(String string) {
        h.error(string);
    }

    @Override
    public void h(String string) {
        if (this.D()) {
            h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public d b(d d2) {
        if (this.u != null) {
            d2.g().a("Player Count", () -> this.u.n() + " / " + this.u.o() + "; " + this.u.t());
        }
        d2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (wy wy2 : this.ae.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(wy2.e());
                if (wy2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.au != null) {
            d2.g().a("Server Id", () -> this.au);
        }
        return d2;
    }

    public boolean E() {
        return this.k != null;
    }

    @Override
    public void a(jn jn2) {
        h.info(jn2.getString());
    }

    public KeyPair F() {
        return this.H;
    }

    public int G() {
        return this.s;
    }

    @Override
    public void a(int n2) {
        this.s = n2;
    }

    public String H() {
        return this.I;
    }

    public void i(String string) {
        this.I = string;
    }

    public boolean I() {
        return this.I != null;
    }

    public String J() {
        return this.J;
    }

    public void j(String string) {
        this.K = string;
    }

    public String K() {
        return this.K;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(ahd ahd2, boolean bl2) {
        for (vi vi2 : this.x()) {
            cog cog2 = vi2.p_();
            if (!bl2 && cog2.x()) continue;
            if (cog2.r()) {
                cog2.a(ahd.d);
                vi2.a(true, true);
                continue;
            }
            if (this.I()) {
                cog2.a(ahd2);
                vi2.a(vi2.ac() != ahd.a, true);
                continue;
            }
            cog2.a(ahd2);
            vi2.a(this.L(), this.A);
        }
        this.ad().t().forEach(this::a);
    }

    public void d(boolean bl2) {
        for (vi vi2 : this.x()) {
            cog cog2 = vi2.p_();
            cog2.e(bl2);
        }
        this.ad().t().forEach(this::a);
    }

    @Override
    private void a(vj vj2) {
        cog cog2 = vj2.s().p_();
        vj2.b.a(new ks(cog2.w(), cog2.x()));
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.L;
    }

    public void e(boolean bl2) {
        this.L = bl2;
    }

    public void f(boolean bl2) {
        this.M = bl2;
    }

    public coj N() {
        return this.i;
    }

    public String O() {
        return this.N;
    }

    public String P() {
        return this.O;
    }

    public void a(String string, String string2) {
        this.N = string;
        this.O = string2;
    }

    @Override
    public void a(ahn ahn22) {
        ahn ahn22;
        ahn22.a("whitelist_enabled", false);
        ahn22.a("whitelist_count", 0);
        if (this.u != null) {
            ahn22.a("players_current", this.z());
            ahn22.a("players_max", this.A());
            ahn22.a("players_seen", this.a(byi.a).w().d().length);
        }
        ahn22.a("uses_auth", this.y);
        ahn22.a("gui_state", this.ah() ? "enabled" : "disabled");
        ahn22.a("run_time", (p.b() - ahn22.g()) / 60L * 1000L);
        ahn22.a("avg_tick_ms", (int)(zv.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (vi vi2 : this.x()) {
            if (vi2 == null) continue;
            cog cog2 = vi2.p_();
            ahn22.a("world[" + n2 + "][dimension]", vi2.q.p());
            ahn22.a("world[" + n2 + "][mode]", (Object)cog2.p());
            ahn22.a("world[" + n2 + "][difficulty]", (Object)vi2.ac());
            ahn22.a("world[" + n2 + "][hardcore]", cog2.r());
            ahn22.a("world[" + n2 + "][generator_name]", cog2.s().a());
            ahn22.a("world[" + n2 + "][generator_version]", cog2.s().e());
            ahn22.a("world[" + n2 + "][height]", this.F);
            ahn22.a("world[" + n2 + "][chunks_loaded]", vi2.m().g());
            ++n2;
        }
        ahn22.a("worlds", n2);
    }

    public abstract boolean R();

    public boolean S() {
        return this.y;
    }

    @Override
    public void g(boolean bl2) {
        this.y = bl2;
    }

    public boolean T() {
        return this.z;
    }

    @Override
    public void h(boolean bl2) {
        this.z = bl2;
    }

    public boolean U() {
        return this.A;
    }

    public void i(boolean bl2) {
        this.A = bl2;
    }

    public boolean V() {
        return this.B;
    }

    public abstract boolean W();

    public void j(boolean bl2) {
        this.B = bl2;
    }

    public boolean X() {
        return this.C;
    }

    public void k(boolean bl2) {
        this.C = bl2;
    }

    public boolean Y() {
        return this.D;
    }

    public void l(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean Z();

    public String aa() {
        return this.E;
    }

    public void k(String string) {
        this.E = string;
    }

    public int ab() {
        return this.F;
    }

    public void b(int n2) {
        this.F = n2;
    }

    public boolean ac() {
        return this.w;
    }

    public xt ad() {
        return this.u;
    }

    @Override
    public void a(xt xt2) {
        this.u = xt2;
    }

    public abstract boolean ae();

    @Override
    public void a(bhj bhj2) {
        for (vi vi2 : this.x()) {
            vi2.p_().a(bhj2);
        }
    }

    @Nullable
    public vz af() {
        return this.n;
    }

    public boolean ag() {
        return this.P;
    }

    public boolean ah() {
        return false;
    }

    public abstract boolean a(bhj var1, boolean var2, int var3);

    public int ai() {
        return this.x;
    }

    public void aj() {
        this.S = true;
    }

    public ahn ak() {
        return this.j;
    }

    public int am() {
        return 16;
    }

    public boolean a(bhm bhm2, ev ev2, awb awb2) {
        return false;
    }

    public void m(boolean bl2) {
        this.T = bl2;
    }

    public boolean an() {
        return this.T;
    }

    public int ap() {
        return this.G;
    }

    public void c(int n2) {
        this.G = n2;
    }

    public MinecraftSessionService aq() {
        return this.V;
    }

    public GameProfileRepository ar() {
        return this.W;
    }

    public xp as() {
        return this.X;
    }

    public qd at() {
        return this.o;
    }

    public void au() {
        this.Y = 0L;
    }

    public int av() {
        return 29999984;
    }

    @Override
    public boolean aw() {
        return super.aw() && !this.ac();
    }

    @Override
    public Thread ax() {
        return this.g;
    }

    public int ay() {
        return 256;
    }

    public long az() {
        return this.Z;
    }

    public DataFixer aA() {
        return this.q;
    }

    public int a(@Nullable vi vi2) {
        if (vi2 != null) {
            return vi2.T().c(bhi.q);
        }
        return 10;
    }

    public re aB() {
        return this.am;
    }

    public rf aC() {
        return this.an;
    }

    public void aD() {
        if (!this.bc()) {
            this.execute(this::aD);
            return;
        }
        this.ad().i();
        this.ae.a();
        this.b(this.a(byi.a).p_());
        this.ad().u();
    }

    private void b(cog cog2) {
        ArrayList arrayList = Lists.newArrayList(this.ae.d());
        for (wy wy3 : this.ae.b()) {
            if (cog2.N().contains(wy3.e()) || arrayList.contains(wy3)) continue;
            h.info("Found new data pack {}, loading it automatically", (Object)wy3.e());
            wy3.h().a(arrayList, wy3, (T wy2) -> wy2, false);
        }
        this.ae.a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.ae.d().forEach(wy2 -> arrayList2.add(wy2.d()));
        CompletableFuture<aad> completableFuture = this.ad.a(this.at, (Executor)this, arrayList2, CompletableFuture.completedFuture(aad.a));
        this.c(completableFuture::isDone);
        try {
            completableFuture.get();
        }
        catch (Exception \u26033) {
            h.error("Failed to reload data packs", (Throwable)\u26033);
        }
        cog2.O().clear();
        cog2.N().clear();
        this.ae.d().forEach(wy2 -> cog2.O().add(wy2.e()));
        this.ae.b().forEach(wy2 -> {
            if (!this.ae.d().contains(wy2)) {
                cog2.N().add(wy2.e());
            }
        });
    }

    @Override
    public void a(cd cd2) {
        if (!this.aP()) {
            return;
        }
        xt xt2 = cd2.j().ad();
        ya \u26032 = xt2.j();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(xt2.t());
        for (vj vj2 : \u26033) {
            if (\u26032.a(vj2.dI())) continue;
            vj2.b.b(new jx("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public xe aE() {
        return this.ad;
    }

    public wv<wy> aF() {
        return this.ae;
    }

    public ce aH() {
        return this.ag;
    }

    public cd aI() {
        return new cd(this, this.a(byi.a) == null ? csb.a : new csb(this.a(byi.a).o_()), csa.a, this.a(byi.a), 4, "Server", new jw("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public ben aJ() {
        return this.ah;
    }

    public zg aK() {
        return this.ai;
    }

    public rh aL() {
        return this.aj;
    }

    public cox aM() {
        return this.al;
    }

    public bhi aN() {
        return this.a(byi.a).T();
    }

    public rk aO() {
        return this.ak;
    }

    public boolean aP() {
        return this.ap;
    }

    public void n(boolean bl2) {
        this.ap = bl2;
    }

    public float aQ() {
        return this.as;
    }

    public int a(GameProfile gameProfile) {
        if (this.ad().h(gameProfile)) {
            xv xv2 = (xv)this.ad().l().b(gameProfile);
            if (xv2 != null) {
                return xv2.a();
            }
            if (this.b(gameProfile)) {
                return 4;
            }
            if (this.I()) {
                return this.ad().v() ? 4 : 0;
            }
            return this.j();
        }
        return 0;
    }

    public zo aR() {
        return this.ao;
    }

    public agg aS() {
        return this.m;
    }

    public Executor aT() {
        return this.at;
    }

    public abstract boolean b(GameProfile var1);

    @Override
    public /* synthetic */ boolean c(Runnable runnable) {
        return this.a((ri)runnable);
    }

    @Override
    public /* synthetic */ Runnable d(Runnable runnable) {
        return this.a(runnable);
    }
}

