/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends agl<rh>
implements ahi,
cc,
AutoCloseable,
Runnable {
    private static final Logger i = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final bhl c = new bhl("North Carolina".hashCode(), bhe.b, true, false, bho.b).a();
    private final cod j;
    private final ahh k = new ahh("server", this, p.b());
    private final File l;
    private final List<Runnable> m = Lists.newArrayList();
    private final aga n = new aga(this::ai);
    private final vx o;
    protected final vq d;
    private final qc p = new qc();
    private final Random q = new Random();
    private final DataFixer r;
    private String s;
    private int t = -1;
    private final Map<byd, vg> u = Maps.newIdentityHashMap();
    private xq v;
    private volatile boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    @Nullable
    private String F;
    private int G;
    private int H;
    public final long[] f = new long[100];
    protected final Map<byd, long[]> g = Maps.newIdentityHashMap();
    @Nullable
    private KeyPair I;
    @Nullable
    private String J;
    private final String K;
    @Nullable
    private String L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private volatile boolean Q;
    private long R;
    @Nullable
    private jm S;
    private boolean T;
    private boolean U;
    @Nullable
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final xm Y;
    private long Z;
    protected final Thread h = p.a(new Thread((Runnable)this, "Server thread"), (T thread2) -> thread2.setUncaughtExceptionHandler((thread, throwable) -> i.error((Object)throwable)));
    private long aa = p.b();
    private long ab;
    private boolean ac;
    private boolean ad;
    private final xc ae = new xi(wi.b, this.h);
    private final wt<ww> af = new wt<ww>(ww::new);
    @Nullable
    private wr ag;
    private final ce ah;
    private final bej ai = new bej();
    private final zd aj = new zd();
    private final rg ak = new rg(this);
    private final rj al = new rj(this);
    private final cor am = new cor();
    private final rd an = new rd();
    private final re ao = new re(this);
    private final zl ap = new zl();
    private boolean aq;
    private boolean ar;
    private boolean as;
    private float at;
    private final Executor au;
    @Nullable
    private String av;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, ce ce2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, xm xm2, vq vq2, String string) {
        super("Server");
        this.e = proxy;
        this.ah = ce2;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = xm2;
        this.l = file;
        this.o = new vx(this);
        this.d = vq2;
        this.j = new cod(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.r = dataFixer;
        this.ae.a(this.aj);
        this.ae.a(this.ai);
        this.ae.a(this.am);
        this.ae.a(this.ao);
        this.ae.a(this.an);
        this.au = p.e();
        this.K = string;
    }

    @Override
    private void a(cnz cnz2) {
        csw csw2 = cnz2.a(csw::new, "scoreboard");
        csw2.a(this.aL());
        this.aL().a(new cnp(csw2));
    }

    protected abstract boolean d() throws IOException;

    @Override
    protected void a(String string) {
        if (this.N().a(string)) {
            i.info("Converting map!");
            this.b(new jw("menu.convertingLevel", new Object[0]));
            this.N().a(string, new zt(){
                private long b = p.b();

                @Override
                public void a(jm jm2) {
                }

                @Override
                public void b(jm jm2) {
                }

                @Override
                public void a(int n2) {
                    if (p.b() - this.b >= 1000L) {
                        this.b = p.b();
                        i.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(jm jm2) {
                }
            });
        }
        if (this.ar) {
            i.info("Forcing world upgrade!");
            coa coa2 = this.N().b(this.J());
            if (coa2 != null) {
                ago ago2 = new ago(this.J(), this.N(), coa2, this.as);
                jm \u26032 = null;
                while (!ago2.b()) {
                    jm jm2 = ago2.g();
                    if (\u26032 != jm2) {
                        \u26032 = jm2;
                        i.info(ago2.g().getString());
                    }
                    if ((\u2603 = ago2.d()) > 0) {
                        int n2 = ago2.e() + ago2.f();
                        i.info("{}% completed ({} / {} chunks)...", (Object)zs.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ac()) {
                        ago2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(jm jm2) {
        this.S = jm2;
    }

    protected void a(String string, String string2, long l22, bho bho2, JsonElement jsonElement) {
        bhl \u26033;
        this.a(string);
        this.b(new jw("menu.loadingLevel", new Object[0]));
        cob cob2 = this.N().a(string, this);
        this.a(this.J(), cob2);
        coa \u26032 = cob2.c();
        if (\u26032 == null) {
            if (this.M()) {
                \u26033 = c;
            } else {
                long l22;
                \u26033 = new bhl(l22, this.g(), this.f(), this.i(), bho2);
                \u26033.a(jsonElement);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new coa(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new bhl(\u26032);
        }
        this.a(cob2.a(), \u26032);
        vp vp2 = this.d.create(11);
        this.a(cob2, \u26032, \u26033, vp2);
        this.a(this.h(), true);
        this.a(vp2);
    }

    protected void a(cob cob2, coa coa22, bhl bhl2, vp vp2) {
        vg vg2;
        if (this.M()) {
            coa22.a(c);
        }
        vg vg3 = new vg(this, this.au, cob2, coa22, byd.a, this.n, vp2);
        this.u.put(byd.a, vg3);
        this.a(vg3.x());
        vg3.q_().b(coa22);
        vg2 = this.a(byd.a);
        if (!coa22.v()) {
            coa coa22;
            try {
                vg2.a(bhl2);
                if (coa22.t() == bho.h) {
                    this.a(coa22);
                }
                coa22.d(true);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception initializing level");
                try {
                    vg2.a(d2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new m(d2);
            }
            coa22.d(true);
        }
        this.ad().a(vg2);
        if (coa22.Q() != null) {
            this.aO().a(coa22.Q());
        }
        for (byd byd2 : byd.a()) {
            if (byd2 == byd.a) continue;
            this.u.put(byd2, new uy(vg2, this, this.au, cob2, byd2, (age)this.n, vp2));
        }
    }

    @Override
    private void a(coa coa2) {
        coa2.f(false);
        coa2.c(true);
        coa2.b(false);
        coa2.a(false);
        coa2.g(1000000000);
        coa2.b(6000L);
        coa2.a(bhe.e);
        coa2.g(false);
        coa2.a(agx.a);
        coa2.e(true);
        coa2.w().a("doDaylightCycle", "false", this);
    }

    protected void a(File file, coa coa2) {
        this.af.a(new wv());
        this.ag = new wr(new File(file, "datapacks"));
        this.af.a(this.ag);
        this.af.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : coa2.P()) {
            ww ww2 = this.af.a(string);
            if (ww2 != null) {
                arrayList.add(ww2);
                continue;
            }
            i.warn("Missing data pack {}", (Object)string);
        }
        this.af.a(arrayList);
        this.b(coa2);
    }

    @Override
    protected void a(vp vp2) {
        this.b(new jw("menu.generatingTerrain", new Object[0]));
        vg vg2 = this.a(byd.a);
        i.info("Preparing start region for dimension " + byd.a(vg2.q.p()));
        ev \u26032 = vg2.o_();
        vp2.a(new bgt(\u26032));
        ve \u26033 = vg2.m();
        \u26033.a().a(500);
        this.aa = p.b();
        \u26033.a(vl.a, new bgt(\u26032), 11, aaa.a);
        while (\u26033.b() != 441) {
            this.aa += 100L;
            this.o();
        }
        this.aa += 100L;
        this.o();
        for (byd byd2 : byd.a()) {
            bhc bhc2 = this.a(byd2).x().b(bhc::new, "chunks");
            if (bhc2 == null) continue;
            vg \u26034 = this.a(byd2);
            LongIterator \u26035 = bhc2.a().iterator();
            while (\u26035.hasNext()) {
                long l2 = \u26035.nextLong();
                bgt \u26036 = new bgt(l2);
                \u26034.m().a(\u26036, true);
            }
        }
        this.aa += 100L;
        this.o();
        vp2.b();
        \u26033.a().a(5);
    }

    protected void a(String string, cob cob2) {
        File file = new File(cob2.a(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                i.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean f();

    public abstract bhe g();

    public abstract agx h();

    public abstract boolean i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (vg vg2 : this.x()) {
            if (!bl2) {
                i.info("Saving chunks for level '{}'/{}", (Object)vg2.p_().j(), (Object)byd.a(vg2.q.p()));
            }
            try {
                vg2.a(null, bl3, vg2.b && !bl4);
            }
            catch (bhj bhj2) {
                i.warn(bhj2.getMessage());
            }
            bl5 = true;
        }
        vg vg2 = this.a(byd.a);
        coa coa2 = vg2.p_();
        vg2.q_().a(coa2);
        coa2.c(this.aO().c());
        vg2.w().a(coa2, this.ad().r());
        return bl5;
    }

    @Override
    public void close() {
        this.l();
    }

    protected void l() {
        i.info("Stopping server");
        if (this.af() != null) {
            this.af().b();
        }
        if (this.v != null) {
            i.info("Saving players");
            this.v.i();
            this.v.s();
        }
        i.info("Saving worlds");
        for (vg vg2 : this.x()) {
            if (vg2 == null) continue;
            vg2.b = false;
        }
        this.a(false, true, false);
        for (vg vg2 : this.x()) {
            if (vg2 == null) continue;
            try {
                vg2.close();
            }
            catch (IOException iOException) {
                i.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
    }

    public String m() {
        return this.s;
    }

    public void b(String string) {
        this.s = string;
    }

    public boolean h_() {
        return this.w;
    }

    @Override
    public void a(boolean bl2) {
        this.w = false;
        if (bl2) {
            try {
                this.h.join();
            }
            catch (InterruptedException interruptedException) {
                i.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.aa = p.b();
                this.p.a(new jv(this.F));
                this.p.a(new qc.c(o.a().getName(), o.a().getProtocolVersion()));
                this.a(this.p);
                while (this.w) {
                    long l2 = p.b() - this.aa;
                    if (l2 > 2000L && this.aa - this.R >= 15000L) {
                        \u2603 = l2 / 50L;
                        i.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.aa += \u2603 * 50L;
                        this.R = this.aa;
                    }
                    this.aa += 50L;
                    if (this.T) {
                        this.T = false;
                        this.n.d().d();
                    }
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aV);
                    this.n.b("nextTickWait");
                    this.ac = true;
                    this.ab = Math.max(p.b() + 50L, this.aa);
                    this.o();
                    this.n.c();
                    this.n.b();
                    this.Q = true;
                }
            } else {
                this.a((d)null);
            }
        }
        catch (Throwable throwable) {
            i.error("Encountered an unexpected exception", throwable);
            d d2 = throwable instanceof m ? this.b(((m)throwable).a()) : this.b(new d("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.s(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (d2.a(\u26032)) {
                i.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                i.error("We were unable to save this crash report to disk.");
            }
            this.a(d2);
        }
        finally {
            try {
                this.x = true;
                this.l();
            }
            catch (Throwable \u26033) {
                i.error("Exception stopping the server", \u26033);
            }
            finally {
                this.t();
            }
        }
    }

    private boolean aV() {
        return this.bg() || p.b() < (this.ac ? this.ab : this.aa);
    }

    protected void o() {
        this.bf();
        this.c(() -> !this.aV());
    }

    protected rh a(Runnable runnable) {
        return new rh(this.y, runnable);
    }

    protected boolean a(rh rh2) {
        return rh2.a() + 3 < this.y || this.aV();
    }

    @Override
    public boolean p() {
        boolean bl2;
        this.ac = bl2 = this.aW();
        return bl2;
    }

    private boolean aW() {
        if (super.p()) {
            return true;
        }
        if (this.aV()) {
            for (vg vg2 : this.x()) {
                if (!vg2.m().d()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(qc qc2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.N().b(this.J(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                qc2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                i.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean q() {
        this.ad = this.ad || this.r().isFile();
        return this.ad;
    }

    public File r() {
        return this.N().b(this.J(), "icon.png");
    }

    public File s() {
        return new File(".");
    }

    @Override
    protected void a(d d2) {
    }

    protected void t() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = p.c();
        ++this.y;
        this.b(booleanSupplier);
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.p.a(new qc.a(this.A(), this.z()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.z(), 12)];
            int \u26032 = zs.a(this.q, 0, this.z() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.t().get(\u26032 + i2).dH();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.p.b().a(gameProfileArray);
        }
        if (this.y % 6000 == 0) {
            i.debug("Autosave started");
            this.n.a("save");
            this.v.i();
            this.a(true, false, false);
            this.n.c();
            i.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.y > 100) {
            this.k.a();
        }
        if (this.y % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = p.c() - l2;
        this.f[this.y % 100] = l3;
        \u2603 = l3;
        this.at = this.at * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = p.c();
        this.ap.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aC().e();
        this.n.b("levels");
        for (vg vg2 : this.x()) {
            long l2 = p.c();
            if (vg2.q.p() == byd.a || this.u()) {
                this.n.a(() -> vg2.p_().j() + " " + fm.x.b(vg2.q.p()));
                if (this.y % 20 == 0) {
                    this.n.a("timeSync");
                    this.v.a(new nb(vg2.R(), vg2.S(), vg2.T().b("doDaylightCycle")), vg2.q.p());
                    this.n.c();
                }
                this.n.a("tick");
                try {
                    vg2.a(booleanSupplier);
                }
                catch (Throwable throwable) {
                    d d2 = d.a(throwable, "Exception ticking world");
                    vg2.a(d2);
                    throw new m(d2);
                }
                this.n.c();
                this.n.c();
            }
            this.g.computeIfAbsent((byd)vg2.q.p(), (Function<byd, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, b(byd ), (Lbyd;)[J)())[this.y % 100] = p.c() - l2;
        }
        this.n.b("connection");
        this.af().c();
        this.n.b("players");
        this.v.d();
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            this.m.get(i2).run();
        }
        this.n.c();
    }

    public boolean u() {
        return true;
    }

    public void b(Runnable runnable) {
        this.m.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            ui \u260316 = new ui(\u260315);
            \u260316.b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            qz \u260318 = new qz(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                i.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.a()) {
                i.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            qu.a();
            qu.c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            xm \u260323 = new xm(\u260322, new File(\u260319, b.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.a().o);
            final ug \u260325 = new ug(new File(\u260319), \u260316, aae.a(), \u260320, \u260321, \u260322, \u260323, vr::new, \u260324);
            \u260325.i((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.a((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.e(optionSet.has((OptionSpec)\u26034));
            \u260325.f(optionSet.has((OptionSpec)\u26035));
            \u260325.b(optionSet.has((OptionSpec)\u26036));
            \u260325.c(optionSet.has((OptionSpec)\u26037));
            \u260325.c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl2 = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.aY();
            }
            \u260325.v();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.a(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new g(i));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            i.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void c(String string) {
        this.av = string;
    }

    protected void b(boolean bl2) {
        this.ar = bl2;
    }

    protected void c(boolean bl2) {
        this.as = bl2;
    }

    public void v() {
        this.h.start();
    }

    public boolean w() {
        return !this.h.isAlive();
    }

    public File d(String string) {
        return new File(this.s(), string);
    }

    public void e(String string) {
        i.info(string);
    }

    public void f(String string) {
        i.warn(string);
    }

    public vg a(byd byd2) {
        return this.u.get(byd2);
    }

    public Iterable<vg> x() {
        return this.u.values();
    }

    public String y() {
        return o.a().getName();
    }

    public int z() {
        return this.v.n();
    }

    public int A() {
        return this.v.o();
    }

    public String[] B() {
        return this.v.e();
    }

    public boolean D() {
        return false;
    }

    @Override
    public void g(String string) {
        i.error(string);
    }

    @Override
    public void h(String string) {
        if (this.D()) {
            i.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public d b(d d2) {
        if (this.v != null) {
            d2.g().a("Player Count", () -> this.v.n() + " / " + this.v.o() + "; " + this.v.t());
        }
        d2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (ww ww2 : this.af.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(ww2.e());
                if (ww2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.av != null) {
            d2.g().a("Server Id", () -> this.av);
        }
        return d2;
    }

    public boolean E() {
        return this.l != null;
    }

    @Override
    public void a(jm jm2) {
        i.info(jm2.getString());
    }

    public KeyPair F() {
        return this.I;
    }

    public int G() {
        return this.t;
    }

    @Override
    public void a(int n2) {
        this.t = n2;
    }

    public String H() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean I() {
        return this.J != null;
    }

    public String J() {
        return this.K;
    }

    public void j(String string) {
        this.L = string;
    }

    public String K() {
        return this.L;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(agx agx2, boolean bl2) {
        for (vg vg2 : this.x()) {
            coa coa2 = vg2.p_();
            if (!bl2 && coa2.y()) continue;
            if (coa2.s()) {
                coa2.a(agx.d);
                vg2.a(true, true);
                continue;
            }
            if (this.I()) {
                coa2.a(agx2);
                vg2.a(vg2.ac() != agx.a, true);
                continue;
            }
            coa2.a(agx2);
            vg2.a(this.L(), this.B);
        }
        this.ad().t().forEach(this::a);
    }

    public void d(boolean bl2) {
        for (vg vg2 : this.x()) {
            coa coa2 = vg2.p_();
            coa2.e(bl2);
        }
        this.ad().t().forEach(this::a);
    }

    @Override
    private void a(vh vh2) {
        coa coa2 = vh2.s().p_();
        vh2.b.a(new kr(coa2.x(), coa2.y()));
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.M;
    }

    public void e(boolean bl2) {
        this.M = bl2;
    }

    public void f(boolean bl2) {
        this.N = bl2;
    }

    public cod N() {
        return this.j;
    }

    public String O() {
        return this.O;
    }

    public String P() {
        return this.P;
    }

    public void a(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(ahh ahh22) {
        ahh ahh22;
        ahh22.a("whitelist_enabled", false);
        ahh22.a("whitelist_count", 0);
        if (this.v != null) {
            ahh22.a("players_current", this.z());
            ahh22.a("players_max", this.A());
            ahh22.a("players_seen", this.a(byd.a).w().d().length);
        }
        ahh22.a("uses_auth", this.z);
        ahh22.a("gui_state", this.ah() ? "enabled" : "disabled");
        ahh22.a("run_time", (p.b() - ahh22.g()) / 60L * 1000L);
        ahh22.a("avg_tick_ms", (int)(zs.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (vg vg2 : this.x()) {
            if (vg2 == null) continue;
            coa coa2 = vg2.p_();
            ahh22.a("world[" + n2 + "][dimension]", vg2.q.p());
            ahh22.a("world[" + n2 + "][mode]", (Object)coa2.q());
            ahh22.a("world[" + n2 + "][difficulty]", (Object)vg2.ac());
            ahh22.a("world[" + n2 + "][hardcore]", coa2.s());
            ahh22.a("world[" + n2 + "][generator_name]", coa2.t().a());
            ahh22.a("world[" + n2 + "][generator_version]", coa2.t().e());
            ahh22.a("world[" + n2 + "][height]", this.G);
            ahh22.a("world[" + n2 + "][chunks_loaded]", vg2.m().g());
            ++n2;
        }
        ahh22.a("worlds", n2);
    }

    public abstract boolean R();

    public boolean S() {
        return this.z;
    }

    @Override
    public void g(boolean bl2) {
        this.z = bl2;
    }

    public boolean T() {
        return this.A;
    }

    @Override
    public void h(boolean bl2) {
        this.A = bl2;
    }

    public boolean U() {
        return this.B;
    }

    public void i(boolean bl2) {
        this.B = bl2;
    }

    public boolean V() {
        return this.C;
    }

    public abstract boolean W();

    public void j(boolean bl2) {
        this.C = bl2;
    }

    public boolean X() {
        return this.D;
    }

    public void k(boolean bl2) {
        this.D = bl2;
    }

    public boolean Y() {
        return this.E;
    }

    public void l(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean Z();

    public String aa() {
        return this.F;
    }

    public void k(String string) {
        this.F = string;
    }

    public int ab() {
        return this.G;
    }

    public void b(int n2) {
        this.G = n2;
    }

    public boolean ac() {
        return this.x;
    }

    public xq ad() {
        return this.v;
    }

    @Override
    public void a(xq xq2) {
        this.v = xq2;
    }

    public abstract boolean ae();

    @Override
    public void a(bhe bhe2) {
        for (vg vg2 : this.x()) {
            vg2.p_().a(bhe2);
        }
    }

    @Nullable
    public vx af() {
        return this.o;
    }

    public boolean ag() {
        return this.Q;
    }

    public boolean ah() {
        return false;
    }

    public abstract boolean a(bhe var1, boolean var2, int var3);

    public int ai() {
        return this.y;
    }

    public void aj() {
        this.T = true;
    }

    public ahh ak() {
        return this.k;
    }

    public int am() {
        return 16;
    }

    public boolean a(bhh bhh2, ev ev2, avx avx2) {
        return false;
    }

    public void m(boolean bl2) {
        this.U = bl2;
    }

    public boolean an() {
        return this.U;
    }

    public int ap() {
        return this.H;
    }

    public void c(int n2) {
        this.H = n2;
    }

    public MinecraftSessionService aq() {
        return this.W;
    }

    public GameProfileRepository ar() {
        return this.X;
    }

    public xm as() {
        return this.Y;
    }

    public qc at() {
        return this.p;
    }

    public void au() {
        this.Z = 0L;
    }

    public int av() {
        return 29999984;
    }

    @Override
    public boolean aw() {
        return super.aw() && !this.ac();
    }

    @Override
    public Thread ax() {
        return this.h;
    }

    public int ay() {
        return 256;
    }

    public long az() {
        return this.aa;
    }

    public DataFixer aA() {
        return this.r;
    }

    public int a(@Nullable vg vg2) {
        if (vg2 != null) {
            return vg2.T().c("spawnRadius");
        }
        return 10;
    }

    public rd aB() {
        return this.an;
    }

    public re aC() {
        return this.ao;
    }

    public void aD() {
        if (!this.bc()) {
            this.execute(this::aD);
            return;
        }
        this.ad().i();
        this.af.a();
        this.b(this.a(byd.a).p_());
        this.ad().u();
    }

    private void b(coa coa2) {
        ArrayList arrayList = Lists.newArrayList(this.af.d());
        for (ww ww3 : this.af.b()) {
            if (coa2.O().contains(ww3.e()) || arrayList.contains(ww3)) continue;
            i.info("Found new data pack {}, loading it automatically", (Object)ww3.e());
            ww3.h().a(arrayList, ww3, (T ww2) -> ww2, false);
        }
        this.af.a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.af.d().forEach(ww2 -> arrayList2.add(ww2.d()));
        CompletableFuture<aaa> completableFuture = this.ae.a(this.au, (Executor)this, arrayList2, CompletableFuture.completedFuture(aaa.a));
        this.c(completableFuture::isDone);
        coa2.P().clear();
        coa2.O().clear();
        this.af.d().forEach(ww2 -> coa2.P().add(ww2.e()));
        this.af.b().forEach(ww2 -> {
            if (!this.af.d().contains(ww2)) {
                coa2.O().add(ww2.e());
            }
        });
    }

    @Override
    public void a(cd cd2) {
        if (!this.aP()) {
            return;
        }
        xq xq2 = cd2.j().ad();
        xx \u26032 = xq2.j();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(xq2.t());
        for (vh vh2 : \u26033) {
            if (\u26032.a(vh2.dH())) continue;
            vh2.b.b(new jw("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public xc aE() {
        return this.ae;
    }

    public wt<ww> aF() {
        return this.af;
    }

    public ce aH() {
        return this.ah;
    }

    public cd aI() {
        return new cd(this, this.a(byd.a) == null ? crv.a : new crv(this.a(byd.a).o_()), cru.a, this.a(byd.a), 4, "Server", new jv("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bej aJ() {
        return this.ai;
    }

    public zd aK() {
        return this.aj;
    }

    public rg aL() {
        return this.ak;
    }

    public cor aM() {
        return this.am;
    }

    public bhd aN() {
        return this.a(byd.a).T();
    }

    public rj aO() {
        return this.al;
    }

    public boolean aP() {
        return this.aq;
    }

    public void n(boolean bl2) {
        this.aq = bl2;
    }

    public float aQ() {
        return this.at;
    }

    public int a(GameProfile gameProfile) {
        if (this.ad().h(gameProfile)) {
            xs xs2 = (xs)this.ad().l().b(gameProfile);
            if (xs2 != null) {
                return xs2.a();
            }
            if (this.b(gameProfile)) {
                return 4;
            }
            if (this.I()) {
                return this.ad().v() ? 4 : 0;
            }
            return this.j();
        }
        return 0;
    }

    public zl aR() {
        return this.ap;
    }

    public aga aS() {
        return this.n;
    }

    public Executor aT() {
        return this.au;
    }

    public abstract boolean b(GameProfile var1);

    @Override
    public /* synthetic */ boolean c(Runnable runnable) {
        return this.a((rh)runnable);
    }

    @Override
    public /* synthetic */ Runnable d(Runnable runnable) {
        return this.a(runnable);
    }

    private static /* synthetic */ long[] b(byd byd2) {
        return new long[100];
    }
}

